/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedOptimProblem;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.Courant;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.Fletcher;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.PenaltyFunction;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.SumOfPenalties;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.ZERO;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class PenaltyMethodMinimizer
implements ConstrainedMinimizer {
    public final UnconstrainedMinimizer solver;
    public static final PenaltyFunctionFactory DEFAULT_PENALTY_FUNCTION_FACTORY = new PenaltyFunctionFactory(){
        {
            1 a2;
        }

        @Override
        public PenaltyFunction getPenaltyFunction(ConstrainedOptimProblem problem) {
            if (problem.getEqualityConstraints() == null && problem.getLessThanConstraints() == null) {
                return new ZERO(problem.dimension());
            }
            PenaltyFunction[] penaltyFunctionArray = new PenaltyFunction[2];
            penaltyFunctionArray[0] = problem.getEqualityConstraints() != null ? new Courant(problem.getEqualityConstraints()) : new ZERO(problem.dimension());
            penaltyFunctionArray[1] = problem.getLessThanConstraints() != null ? new Fletcher(problem.getLessThanConstraints()) : new ZERO(problem.dimension());
            return new SumOfPenalties(penaltyFunctionArray);
        }
    };
    private State E;
    public final double gamma;
    public final PenaltyFunctionFactory penaltyFunctionFactory;

    public PenaltyMethodMinimizer(PenaltyFunctionFactory penaltyFunctionFactory, double gamma, UnconstrainedMinimizer solver) {
        this.penaltyFunctionFactory = penaltyFunctionFactory;
        this.gamma = gamma;
        this.solver = solver;
    }

    public PenaltyMethodMinimizer() {
        this(1.0E30);
    }

    @Override
    public Vector search(Vector ... initials) {
        RealScalarFunction a2 = this.b(this.gamma);
        this.solver.solve(a2, this.E.tol, this.E.maxIterations);
        this.E.xmin = this.solver.search(initials);
        return this.E.xmin;
    }

    private RealScalarFunction b(final double a2) {
        PenaltyMethodMinimizer a3;
        return new RealScalarFunction(){

            @Override
            public double evaluate(double ... x) {
                double a22 = ((PenaltyMethodMinimizer)PenaltyMethodMinimizer.this).E.problem.f().evaluate(x);
                double a3 = ((PenaltyMethodMinimizer)PenaltyMethodMinimizer.this).E.penalty.evaluate(x);
                return a22 + a2 * a3;
            }

            @Override
            public int dimensionOfRange() {
                return ((PenaltyMethodMinimizer)PenaltyMethodMinimizer.this).E.problem.f().dimensionOfRange();
            }
            {
                2 a22;
            }

            @Override
            public int dimensionOfDomain() {
                return ((PenaltyMethodMinimizer)PenaltyMethodMinimizer.this).E.problem.f().dimensionOfDomain();
            }
        };
    }

    @Override
    public double minimum() {
        return this.E.problem.f().evaluate(this.E.xmin.toArray());
    }

    @Override
    public void solve(ConstrainedOptimProblem problem, double tol, int maxIterations) {
        this.E = new State(problem, this.penaltyFunctionFactory.getPenaltyFunction(problem), tol, maxIterations, null);
    }

    public PenaltyMethodMinimizer(double gamma) {
        this(DEFAULT_PENALTY_FUNCTION_FACTORY, gamma, new NelderMead());
    }

    private static class State {
        public final ConstrainedOptimProblem problem;
        public final PenaltyFunction penalty;
        public Vector xmin;
        public final double tol;
        public final int maxIterations;

        private State(ConstrainedOptimProblem a2, PenaltyFunction a3, double a4, int a5) {
            State a6;
            a6.problem = a2;
            a6.penalty = a3;
            a6.tol = a4;
            a6.maxIterations = a5;
        }

        public /* synthetic */ State(ConstrainedOptimProblem a2, PenaltyFunction a3, double a4, int a5, 1 a6) {
            a7(a2, a3, a4, a5);
            State a7;
        }
    }

    public static interface PenaltyFunctionFactory {
        public PenaltyFunction getPenaltyFunction(ConstrainedOptimProblem var1);
    }
}

