/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod;

import com.numericalmethod.suanshu.optimization.constrained.constraint.Constraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.LessThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.MultiplierPenalty;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Fletcher
extends MultiplierPenalty {
    public Fletcher(LessThanConstraints constraints, double[] weights) {
        super((Constraints)constraints, weights);
    }

    public Fletcher(LessThanConstraints constraints, double weights) {
        super((Constraints)constraints, weights);
    }

    @Override
    public double evaluate(double ... x) {
        int a2;
        Vector a3 = this.constraints.evaluate(x);
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3.size()) {
            double a5 = a3.get(a2);
            a4 += this.weights[a2 - 1] * Math.max(a5, 0.0) * Math.max(a5, 0.0);
            n = ++a2;
        }
        return a4 /= 2.0;
    }

    public Fletcher(LessThanConstraints constraints) {
        this(constraints, 1.0);
    }
}

