/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.general;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.LessThanConstraints;

public class ConstrainedOptimProblem {
    private final RealScalarFunction k;
    private final LessThanConstraints L;
    private final EqualityConstraints E;

    public int dimension() {
        return this.k.dimensionOfDomain();
    }

    public ConstrainedOptimProblem(RealScalarFunction f2, EqualityConstraints equal, LessThanConstraints less) {
        SuanShuUtils.assertArgument(equal == null || f2.dimensionOfDomain() == equal.dimensionOfDomain(), "dimension of equalities does not match that of the objective function", new Object[0]);
        SuanShuUtils.assertArgument(less == null || f2.dimensionOfDomain() == less.dimensionOfDomain(), "dimension of less-than inequalities does not match that of the objective function", new Object[0]);
        this.k = f2;
        this.E = equal;
        this.L = less;
    }

    public EqualityConstraints getEqualityConstraints() {
        return this.E;
    }

    public LessThanConstraints getLessThanConstraints() {
        return this.L;
    }

    public RealScalarFunction f() {
        return this.k;
    }

    public ConstrainedOptimProblem(ConstrainedOptimProblem that) {
        this.k = that.f();
        this.E = that.getEqualityConstraints();
        this.L = that.getLessThanConstraints();
    }
}

