/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming;

import com.numericalmethod.suanshu.analysis.function.rn2r1.QuadraticFunction;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LinearSystemSolver;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.QPSolution;
import com.numericalmethod.suanshu.optimization.constrained.convex.quadraticprogramming.problem.QPProblemEqualityConstraints;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.operation.VectorSpace;

public class SimpleQPSolver {
    public static QPSolution solve(QuadraticFunction f2, final double epsilon) throws QPInfeasible {
        Object a2;
        Matrix a3 = f2.Hessian();
        Vector a4 = f2.p();
        double[] a5 = new Eigen(a3, Eigen.Method.QR, epsilon).getRealEigenvalues();
        final double a6 = DoubleArrayMath.min(a5);
        if (a6 < 0.0) {
            throw new IllegalArgumentException("the Hessian matrix is not positive (semi-)definite");
        }
        if (a6 < epsilon && !((VectorSpace)(a2 = new VectorSpace(a3, epsilon))).isSpanned(a4)) {
            throw new QPInfeasible();
        }
        a2 = new LinearSystemSolver(a3, epsilon);
        final Vector a7 = ((LinearSystemSolver)a2).solve(a4.scaled(-1.0));
        return new QPSolution(){
            {
                1 a2;
            }

            @Override
            public ImmutableVector minimizer() {
                return new ImmutableVector(a7);
            }

            @Override
            public boolean isUnique() {
                return a6 >= epsilon;
            }
        };
    }

    public static QPSolution solve(QuadraticFunction f2) throws QPInfeasible {
        return SimpleQPSolver.solve(f2, SuanShuUtils.autoEpsilon(f2.Hessian()));
    }

    static {
        Package.getInstance("OPTIM").isValidated();
    }

    public static QPSolution solve(QuadraticFunction f2, LinearEqualityConstraints equal, double epsilon) throws QPInfeasible {
        QPProblemEqualityConstraints a2 = new QPProblemEqualityConstraints(f2, equal);
        final QPSolution a3 = SimpleQPSolver.solve((QuadraticFunction)a2, epsilon);
        final ImmutableVector a4 = a2.getSolutionToOriginalProblem(a3.minimizer());
        return new QPSolution(){

            @Override
            public boolean isUnique() {
                return a3.isUnique();
            }
            {
                2 a2;
            }

            @Override
            public ImmutableVector minimizer() {
                return new ImmutableVector(a4);
            }
        };
    }

    public static QPSolution solve(QuadraticFunction f2, LinearEqualityConstraints equal) throws QPInfeasible {
        return SimpleQPSolver.solve(f2, equal, SuanShuUtils.autoEpsilon(f2.Hessian()));
    }
}

