/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.constraint.linear;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.BoxConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearLessThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.exception.LPInfeasible;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.GeneralLPProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.GeneralLPSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.solver.LPSimplexSolution;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class LinearGreaterThanConstraints
extends LinearConstraints
implements GreaterThanConstraints {
    @Override
    public LinearLessThanConstraints toLessThanConstraints() {
        return new LinearLessThanConstraints(this.A().scaled(-1.0), this.b().scaled(-1.0));
    }

    public Vector getFeasibleInitialPoint(LinearEqualityConstraints equal) {
        int a2;
        Object a3;
        SuanShuUtils.assertArgument(equal == null || this.dimensionOfDomain() == equal.dimensionOfDomain(), "the domains (variables) of both inequality and equality constraints must match", new Object[0]);
        int a4 = this.dimensionOfDomain();
        DenseVector a5 = new DenseVector(a4 + 1);
        a5.set(a4 + 1, 1.0);
        DenseMatrix a6 = new DenseMatrix(R.rep(1.0, this.dimensionOfRange()), this.dimensionOfRange(), 1);
        Matrix[] matrixArray = new Matrix[2];
        matrixArray[0] = this.A();
        matrixArray[1] = a6;
        DenseMatrix a7 = CreateMatrix.cbind(matrixArray);
        LinearGreaterThanConstraints a8 = new LinearGreaterThanConstraints(a7, this.b());
        LinearEqualityConstraints a9 = null;
        if (equal != null) {
            Matrix[] matrixArray2 = new Matrix[2];
            matrixArray2[0] = equal.A();
            matrixArray2[1] = new DenseMatrix(equal.A().nRows(), 1);
            a3 = CreateMatrix.cbind(matrixArray2);
            a9 = new LinearEqualityConstraints((Matrix)a3, equal.b());
        }
        a3 = new BoxConstraints.Bound[a4];
        int n = a2 = 0;
        while (n < a4) {
            a3[a2] = new BoxConstraints.Bound(a2 + 1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            n = ++a2;
        }
        BoxConstraints a22 = new BoxConstraints(a4, (BoxConstraints.Bound)a3);
        GeneralLPProblem a10 = new GeneralLPProblem(a5, a8, null, a9, a22);
        GeneralLPSolver a11 = new GeneralLPSolver();
        try {
            LPSimplexSolution a12 = a11.solve(a10);
            return a12.minimizer();
        }
        catch (LPInfeasible a13) {
            throw new RuntimeException("LP problem not setup properly; there is no feasible initial");
        }
    }

    public LinearGreaterThanConstraints(Matrix A, Vector b2) {
        super(A, b2);
    }

    public Vector getFeasibleInitialPoint() {
        return this.getFeasibleInitialPoint(null);
    }
}

