/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.constraint.linear;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.Constraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearEqualityConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearLessThanConstraints;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public abstract class LinearConstraints
implements Constraints {
    private final ImmutableMatrix L;
    private final ImmutableVector E;

    public static LinearConstraints concat(LinearConstraints ... groups) {
        int a2;
        Matrix[] a3 = new Matrix[groups.length];
        Vector[] a4 = new Vector[groups.length];
        Class<?> a5 = null;
        int n = a2 = 0;
        while (n < groups.length) {
            if (groups[a2] != null) {
                if (a5 == null) {
                    a5 = groups[a2].getClass();
                } else {
                    SuanShuUtils.assertArgument(groups[a2].getClass() == a5, "those must all have the same constraint type", new Object[0]);
                }
                a3[a2] = groups[a2].A();
                a4[a2] = groups[a2].b();
            }
            n = ++a2;
        }
        DenseMatrix a22 = CreateMatrix.rbind(a3);
        Vector a6 = CreateVector.concat(a4);
        try {
            Class[] classArray = new Class[2];
            classArray[0] = Matrix.class;
            classArray[1] = Vector.class;
            Constructor<?> a7 = a5.getConstructor(classArray);
            Object[] objectArray = new Object[2];
            objectArray[0] = a22;
            objectArray[1] = a6;
            LinearConstraints a8 = (LinearConstraints)a7.newInstance(objectArray);
            return a8;
        }
        catch (Exception a9) {
            throw new RuntimeException(a9);
        }
    }

    @Override
    public ArrayList<RealScalarFunction> getConstraints() {
        int a2;
        ArrayList<RealScalarFunction> a3 = new ArrayList<RealScalarFunction>();
        int n = a2 = 1;
        while (n <= this.L.nRows()) {
            final int a4 = a2++;
            RealScalarFunction a5 = new RealScalarFunction(){

                @Override
                public double evaluate(double ... x) {
                    double a2 = LinearConstraints.this.L.getRow(a4).innerProduct(new DenseVector(x));
                    return a2 - LinearConstraints.this.E.get(a4);
                }
                {
                    1 a2;
                }

                @Override
                public int dimensionOfDomain() {
                    return LinearConstraints.this.L.nCols();
                }

                @Override
                public int dimensionOfRange() {
                    return 1;
                }
            };
            a3.add(a5);
            n = a2;
        }
        return a3;
    }

    @Override
    public int dimensionOfDomain() {
        return this.L.nCols();
    }

    public LinearConstraints(Matrix A, Vector b2) {
        this.L = new ImmutableMatrix(A);
        this.E = new ImmutableVector(b2);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append(this.A().toString());
        if (this.getClass() == LinearGreaterThanConstraints.class) {
            a2.append(">=");
        } else if (this.getClass() == LinearLessThanConstraints.class) {
            a2.append("<=");
        } else if (this.getClass() == LinearEqualityConstraints.class) {
            a2.append("=");
        } else {
            throw new RuntimeException("unrecognized LinearConstraints subclass");
        }
        a2.append("\n");
        a2.append(this.b().toString());
        return a2.toString();
    }

    public ImmutableVector b() {
        return this.E;
    }

    public Matrix getActiveA(Vector x, double epsilon) {
        int[] a2 = DoubleUtils.Collection2intArray(this.getActiveRows(x, epsilon));
        int[] a3 = R.seq(1, this.L.nCols());
        return CreateMatrix.subMatrix(this.L, a2, a3);
    }

    public List<Integer> getActiveRows(Vector x, double epsilon) {
        int a2;
        ArrayList<Integer> a3 = new ArrayList<Integer>();
        int n = a2 = 1;
        while (n <= this.L.nRows()) {
            double a4 = this.L.getRow(a2).innerProduct(x) - this.E.get(a2);
            if (Math.abs(a4) < epsilon) {
                a3.add(a2);
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public int dimensionOfRange() {
        return this.L.nRows();
    }

    public ImmutableMatrix A() {
        return this.L;
    }

    @Override
    public Vector evaluate(double ... v) {
        DenseVector a2 = new DenseVector(v);
        Vector a3 = this.L.multiply(a2).minus(this.E);
        return a3;
    }
}

