/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.constraint.linear;

import com.numericalmethod.suanshu.interval.DoubleInterval;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.constraint.GreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearGreaterThanConstraints;
import com.numericalmethod.suanshu.optimization.constrained.constraint.linear.LinearLessThanConstraints;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Arrays;

public class BoxConstraints {
    private final int L;
    private final ArrayList<Bound> E;

    public LinearLessThanConstraints getUpperBounds() {
        Object a2;
        Object a3;
        ArrayList<DenseVector> a4 = new ArrayList<DenseVector>();
        ArrayList<Double> a5 = new ArrayList<Double>();
        Object object = a3 = this.E.iterator();
        while (object.hasNext()) {
            a2 = a3.next();
            Double a6 = ((Bound)a2).upper();
            if (a6 == Double.POSITIVE_INFINITY) {
                object = a3;
                continue;
            }
            a5.add(a6);
            DenseVector a7 = new DenseVector(this.L, 0.0);
            a7.set(((Bound)a2).index, 1.0);
            a4.add(a7);
            object = a3;
        }
        if (a4.isEmpty()) {
            return null;
        }
        a3 = CreateMatrix.rbind(a4.toArray(new Vector[0]));
        a2 = new DenseVector(DoubleUtils.Collection2doubleArray(a5));
        return new LinearLessThanConstraints((Matrix)a3, (Vector)a2);
    }

    public LinearGreaterThanConstraints getLowerBounds() {
        Object a2;
        ArrayList<DenseVector> a3 = new ArrayList<DenseVector>();
        ArrayList<Double> a4 = new ArrayList<Double>();
        Object a5 = this.E.iterator();
        block0: while (true) {
            Object object = a5;
            while (object.hasNext()) {
                a2 = a5.next();
                Double a6 = ((Bound)a2).lower();
                if (a6 == Double.NEGATIVE_INFINITY) continue block0;
                if (a6 == 0.0) {
                    object = a5;
                    continue;
                }
                a4.add(a6);
                DenseVector a7 = new DenseVector(this.L, 0.0);
                a7.set(((Bound)a2).index, 1.0);
                a3.add(a7);
                object = a5;
            }
            break;
        }
        if (a3.isEmpty()) {
            return null;
        }
        a5 = CreateMatrix.rbind(a3.toArray(new Vector[0]));
        a2 = new DenseVector(DoubleUtils.Collection2doubleArray(a4));
        return new LinearGreaterThanConstraints((Matrix)a5, (Vector)a2);
    }

    public BoxConstraints(int dim, Bound ... bounds) {
        this.L = dim;
        this.E = new ArrayList(bounds.length);
        this.E.addAll(Arrays.asList(bounds));
    }

    public ArrayList<Bound> getBounds() {
        ArrayList<Bound> a2 = new ArrayList<Bound>(this.E.size());
        a2.addAll(this.E);
        return a2;
    }

    public LinearLessThanConstraints toLessThanConstraints() {
        LinearGreaterThanConstraints a2 = this.getLowerBounds();
        LinearLessThanConstraints a3 = this.getUpperBounds();
        LinearLessThanConstraints a4 = a2.toLessThanConstraints();
        LinearConstraints[] linearConstraintsArray = new LinearConstraints[2];
        linearConstraintsArray[0] = a3;
        linearConstraintsArray[1] = a4;
        return (LinearLessThanConstraints)LinearConstraints.concat(linearConstraintsArray);
    }

    public LinearGreaterThanConstraints toGreaterThanConstraints() {
        GreaterThanConstraints a2 = this.toLessThanConstraints().toGreaterThanConstraints();
        return a2;
    }

    public static class Bound {
        public final int index;
        private DoubleInterval E;

        public double lower() {
            return (Double)this.E.begin();
        }

        public Bound(int index, double lower, double upper) {
            this.index = index;
            this.E = new DoubleInterval(lower, upper);
        }

        public double upper() {
            return (Double)this.E.end();
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.index;
            objectArray[1] = this.E.toString();
            return String.format("x[%d]: %s", objectArray);
        }
    }
}

