/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number.big;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.math.BigInteger;

public class BigIntegerUtils {
    private BigIntegerUtils() {
        BigIntegerUtils a2;
    }

    public static BigInteger permutation(int n, int k) {
        int a2;
        SuanShuUtils.assertArgument(n >= k, "n >= k", new Object[0]);
        SuanShuUtils.assertArgument(k >= 0, "n, k must be 0s or natural numbers", new Object[0]);
        if (n == 0 || k == 0 || k == n) {
            return BigInteger.valueOf(1L);
        }
        BigInteger a3 = BigInteger.valueOf(1L);
        int n2 = a2 = n;
        while (n2 > n - k) {
            a3 = a3.multiply(BigInteger.valueOf(a2));
            n2 = --a2;
        }
        return a3;
    }

    public static BigInteger combination(int n, int k) {
        SuanShuUtils.assertArgument(n >= k, "n >= k", new Object[0]);
        SuanShuUtils.assertArgument(k >= 0, "n, k must be 0s or natural numbers", new Object[0]);
        if (n == 0 || k == 0 || k == n) {
            return BigInteger.valueOf(1L);
        }
        if ((double)k > (double)n / 2.0) {
            k = n - k;
        }
        BigInteger a2 = BigIntegerUtils.permutation(n, k);
        BigInteger a3 = BigIntegerUtils.factorial(k);
        a2 = a2.divide(a3);
        return a2;
    }

    public static BigInteger factorial(int n) {
        int a2;
        SuanShuUtils.assertArgument(n >= 0, "n must be 0 or a natural number", new Object[0]);
        BigInteger a3 = BigInteger.valueOf(1L);
        int n2 = a2 = 2;
        while (n2 <= n) {
            a3 = a3.multiply(BigInteger.valueOf(a2));
            n2 = ++a2;
        }
        return a3;
    }
}

