/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DoubleUtils {
    public static double round(double d2, int scale) {
        SuanShuUtils.assertArgument(scale >= 0, "scale >= 0", new Object[0]);
        if (!DoubleUtils.isN(d2)) {
            return d2;
        }
        BigDecimal a2 = new BigDecimal(d2);
        a2 = a2.setScale(scale, 4);
        return a2.doubleValue();
    }

    public static int maxIndex(boolean moveOnTies, int from, int to, double ... doubles) {
        int a2;
        int a3 = from;
        int n = a2 = from + 1;
        while (n < to) {
            if (doubles[a2] > doubles[a3]) {
                a3 = a2;
            }
            if (moveOnTies && doubles[a2] == doubles[a3]) {
                a3 = a2;
            }
            n = ++a2;
        }
        return a3;
    }

    public static boolean equal(double[] d1, double[] d2, double precision) {
        int a2;
        if (d1.length != d2.length) {
            return false;
        }
        int n = a2 = 0;
        while (n < d1.length) {
            if (!DoubleUtils.equal(d1[a2], d2[a2], precision)) {
                return false;
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean isAllZeros(double[] d2, double epsilon) {
        int a2;
        boolean a3 = true;
        int n = a2 = 0;
        while (n < d2.length) {
            if (!DoubleUtils.equal(d2[a2], 0.0, epsilon)) {
                a3 = false;
                break;
            }
            n = ++a2;
        }
        return a3;
    }

    public static boolean equal(int[] d1, int[] d2) {
        int a2;
        if (d1.length != d2.length) {
            return false;
        }
        int n = a2 = 0;
        while (n < d1.length) {
            if (d1[a2] != d2[a2]) {
                return false;
            }
            n = ++a2;
        }
        return true;
    }

    public static int compare(double d1, double d2, double precision) {
        return Math.abs(d1 - d2) <= precision ? 0 : Double.compare(d1, d2);
    }

    public static int minIndex(double ... doubles) {
        return DoubleUtils.minIndex(true, 0, doubles.length, doubles);
    }

    public static int maxIndex(double ... doubles) {
        return DoubleUtils.maxIndex(true, 0, doubles.length, doubles);
    }

    public static double absoluteError(double x1, double x0) {
        return Math.abs(x1 - x0);
    }

    static {
        Package.getInstance("BASIC").isValidated();
    }

    public static List<Double> doubleArray2ArrayList(double ... arr) {
        int a2;
        ArrayList<Double> a3 = new ArrayList<Double>(arr.length);
        int n = a2 = 0;
        while (n < arr.length) {
            a3.add(new Double(arr[a2]));
            n = ++a2;
        }
        return a3;
    }

    public static ArrayList<Integer> intArray2ArrayList(int[] ary) {
        int a2;
        ArrayList<Integer> a3 = new ArrayList<Integer>(ary.length);
        int n = a2 = 0;
        while (n < ary.length) {
            a3.add(new Integer(ary[a2]));
            n = ++a2;
        }
        return a3;
    }

    public static int minIndex(boolean moveOnTies, int from, int to, double ... doubles) {
        int a2;
        int a3 = from;
        int n = a2 = from + 1;
        while (n < to) {
            if (doubles[a2] < doubles[a3]) {
                a3 = a2;
            }
            if (moveOnTies && doubles[a2] == doubles[a3]) {
                a3 = a2;
            }
            n = ++a2;
        }
        return a3;
    }

    public static int[] Collection2intArray(Collection<Integer> integers) {
        Iterator<Integer> a2;
        int[] a3 = new int[integers.size()];
        int a4 = 0;
        Iterator<Integer> iterator = a2 = integers.iterator();
        while (iterator.hasNext()) {
            Integer a5 = a2.next();
            a3[a4++] = a5;
            iterator = a2;
        }
        return a3;
    }

    public static double[] concat(double[] ... arr) {
        int a2;
        int a3;
        int a4 = 0;
        int n = a3 = 0;
        while (n < arr.length) {
            a4 += arr[a3].length;
            n = ++a3;
        }
        double[] a22 = new double[a4];
        int a5 = 0;
        int n2 = a2 = 0;
        while (n2 < arr.length) {
            int a6;
            int n3 = a6 = 0;
            while (n3 < arr[a2].length) {
                System.arraycopy(arr[a2], 0, a22, a5, arr[a2].length);
                n3 = ++a6;
            }
            a5 += arr[a2].length;
            n2 = ++a2;
        }
        return a22;
    }

    public static double relativeError(double x1, double x0) {
        return Math.abs(x1 / x0 - 1.0);
    }

    public static int[] shellsort(double ... arr) {
        int a2;
        int a3 = arr.length;
        int[] a4 = R.seq(1, a3);
        int n = a2 = Math.round(a3 / 2);
        while (n > 0) {
            int n2 = a2;
            while (n2 < a3) {
                int a5;
                int a6;
                double a7 = arr[a6];
                int a8 = a4[a6];
                int n3 = a6;
                int n4 = a2;
                while (n3 >= n4 && arr[a5 - a2] > a7) {
                    arr[a5] = arr[a5 - a2];
                    a4[a5] = a4[a5 - a2];
                    n3 = a5 - a2;
                    n4 = a2;
                }
                arr[a5] = a7;
                a4[a5] = a8;
                n2 = ++a6;
            }
            n = (int)Math.round((double)a2 / 2.2);
        }
        return a4;
    }

    public static boolean isAnyZero(double[] d2, double epsilon) {
        int a2;
        int n = a2 = 0;
        while (n < d2.length) {
            if (DoubleUtils.equal(0.0, d2[a2], epsilon)) {
                return true;
            }
            n = ++a2;
        }
        return false;
    }

    public static double[] foreach(double[] doubles, UnivariateRealFunction f2) {
        int a2;
        double[] a3 = new double[doubles.length];
        int n = a2 = 0;
        while (n < doubles.length) {
            a3[a2] = f2.evaluate(doubles[a2]);
            n = ++a2;
        }
        return a3;
    }

    public static double[] Collection2doubleArray(Collection<Double> doubles) {
        Iterator<Double> a2;
        double[] a3 = new double[doubles.size()];
        int a4 = 0;
        Iterator<Double> iterator = a2 = doubles.iterator();
        while (iterator.hasNext()) {
            Double a5 = a2.next();
            a3[a4++] = a5;
            iterator = a2;
        }
        return a3;
    }

    public static String doubleArray2StringArray(double ... arr) {
        int a2;
        int a3 = 10;
        StringBuilder a4 = new StringBuilder();
        int n = a2 = 0;
        while (n < arr.length) {
            a4.append(arr[a2]).append(", ");
            if (a2 % 10 == 9) {
                a4.append("\n");
            }
            n = ++a2;
        }
        return a4.toString();
    }

    public static void reverse(double ... arr) {
        double a2 = 0.0;
        int a3 = 0;
        int a4 = arr.length - 1;
        int n = a3;
        while (true) {
            if (n >= arr.length / 2) break;
            a2 = arr[a3];
            arr[a3] = arr[a4];
            arr[a4] = a2;
            --a4;
            n = ++a3;
        }
    }

    public static boolean isThereAnyDuplicate(double ... arr) {
        int a2;
        double[] a3 = Arrays.copyOf(arr, arr.length);
        Arrays.sort(a3);
        boolean a4 = false;
        int n = a2 = 1;
        while (n < a3.length) {
            if (a3[a2 - 1] == a3[a2]) {
                a4 = true;
                break;
            }
            n = ++a2;
        }
        return a4;
    }

    public static int compare(double d1, double d2) {
        if (d1 - d2 == 0.0) {
            return 0;
        }
        return Double.compare(d1, d2);
    }

    private DoubleUtils() {
        DoubleUtils a2;
    }

    public static boolean equal(double[][] d1, double[][] d2, double precision) {
        int a2;
        int a3 = d1.length;
        if (a3 != d2.length) {
            return false;
        }
        int n = a2 = 0;
        while (n < a3) {
            if (d1[a2] == null) {
                if (d2[a2] != null) {
                    return false;
                }
            } else if (d2[a2] == null) {
                if (d1[a2] != null) {
                    return false;
                }
            } else {
                int a4;
                int a5 = d1[a2].length;
                if (a5 != d2[a2].length) {
                    return false;
                }
                int n2 = a4 = 0;
                while (n2 < a5) {
                    if (!DoubleUtils.equal(d1[a2][a4], d2[a2][a4], precision)) {
                        return false;
                    }
                    n2 = ++a4;
                }
            }
            n = ++a2;
        }
        return true;
    }

    public static boolean equal(double d1, double d2, double precision) {
        return DoubleUtils.compare(d1, d2, precision) == 0;
    }

    public static int[] doubleArray2intArray(double ... arr) {
        int a2;
        int[] a3 = new int[arr.length];
        int n = a2 = 0;
        while (n < arr.length) {
            a3[a2] = (int)arr[a2];
            n = ++a2;
        }
        return a3;
    }

    public static boolean isPow2(int n) {
        return (n & n - 1) == 0;
    }

    public static double[] intArray2doubleArray(int ... arr) {
        int a2;
        double[] a3 = new double[arr.length];
        int n = a2 = 0;
        while (n < arr.length) {
            a3[a2] = arr[a2];
            n = ++a2;
        }
        return a3;
    }

    public static void reverse(int ... arr) {
        int a2 = 0;
        int a3 = 0;
        int a4 = arr.length - 1;
        int n = a3;
        while (true) {
            if (n >= arr.length / 2) break;
            a2 = arr[a3];
            arr[a3] = arr[a4];
            arr[a4] = a2;
            --a4;
            n = ++a3;
        }
    }

    public static boolean isN(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static double round(double d2, RoundingScheme dir) {
        double a2 = 0.0;
        switch (dir) {
            case UP: {
                a2 = Math.ceil(d2 - Constant.EPSILON);
                break;
            }
            case DOWN: {
                do {
                } while (false);
                a2 = Math.floor(d2 + Constant.EPSILON);
                break;
            }
            default: {
                a2 = Math.round(d2);
            }
        }
        return a2;
    }

    public static String toString(double[][] arr) {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("{");
        a3.append("\n");
        int n = a2 = 0;
        while (n < arr.length) {
            int a4;
            a3.append("{");
            int n2 = a4 = 0;
            while (n2 < arr[a2].length) {
                a3.append(arr[a2][a4]);
                if (a4 < arr[a2].length - 1) {
                    a3.append(", ");
                }
                n2 = ++a4;
            }
            a3.append("}");
            if (a2 < arr.length - 1) {
                a3.append(",");
            }
            a3.append("\n");
            n = ++a2;
        }
        a3.append("};\n");
        return a3.toString();
    }

    public static final class RoundingScheme
    extends Enum<RoundingScheme> {
        public static final /* enum */ RoundingScheme DEFAULT = new RoundingScheme();
        public static final /* enum */ RoundingScheme UP = new RoundingScheme();
        private static final /* synthetic */ RoundingScheme[] E;
        public static final /* enum */ RoundingScheme DOWN = new RoundingScheme();

        public static RoundingScheme valueOf(String name) {
            return Enum.valueOf(RoundingScheme.class, name);
        }

        static {
            RoundingScheme[] roundingSchemeArray = new RoundingScheme[3];
            roundingSchemeArray[0] = DEFAULT;
            roundingSchemeArray[1] = UP;
            roundingSchemeArray[2] = DOWN;
            E = roundingSchemeArray;
        }

        public static RoundingScheme[] values() {
            return (RoundingScheme[])E.clone();
        }

        private RoundingScheme() {
            RoundingScheme a2;
        }
    }
}

