/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class R {
    public static int[] select(int[] arr, which criterion) {
        int a2;
        ArrayList<Integer> a3 = new ArrayList<Integer>();
        int n = a2 = 0;
        while (n < arr.length) {
            if (criterion.isTrue(arr[a2], a2)) {
                a3.add(arr[a2]);
            }
            n = ++a2;
        }
        return DoubleUtils.Collection2intArray(a3);
    }

    public static double[] select(double[] arr, which criterion) {
        int a2;
        ArrayList<Double> a3 = new ArrayList<Double>();
        int n = a2 = 0;
        while (n < arr.length) {
            if (criterion.isTrue(arr[a2], a2)) {
                a3.add(arr[a2]);
            }
            n = ++a2;
        }
        return DoubleUtils.Collection2doubleArray(a3);
    }

    public static int[] order(double[] arr) {
        return R.order(arr, true);
    }

    public static int[] rep(int value, int times) {
        int a2;
        SuanShuUtils.assertArgument(times >= 0, "the number of repetitions must be a natural number", new Object[0]);
        int[] a3 = new int[times];
        int n = a2 = 0;
        while (n < times) {
            a3[a2] = value;
            n = ++a2;
        }
        return a3;
    }

    public static int[] which(int[] arr, which criterion) {
        int a2;
        double[] a3 = new double[arr.length];
        int n = a2 = 0;
        while (n < arr.length) {
            a3[a2] = arr[a2];
            n = ++a2;
        }
        return R.which(a3, criterion);
    }

    private R() {
        R a2;
    }

    public static double[] diff(double[] arr) {
        return R.diff(arr, 1, 1);
    }

    public static int[] cumsum(int[] arr) {
        int a2;
        SuanShuUtils.assertArgument(arr.length > 0, "arr length > 0", new Object[0]);
        int[] nArray = new int[arr.length];
        int[] a3 = nArray;
        nArray[0] = arr[0];
        int n = a2 = 1;
        while (n < arr.length) {
            a3[a2] = a3[a2 - 1] + arr[a2];
            n = ++a2;
        }
        return a3;
    }

    public static int[] subarray(int[] arr, int[] indices) {
        int a2;
        SuanShuUtils.assertArgument(arr.length > 0, "arr length > 0", new Object[0]);
        SuanShuUtils.assertArgument(indices.length > 0, "indices length > 0", new Object[0]);
        SuanShuUtils.assertArgument(arr.length >= indices.length, "too many indices", new Object[0]);
        int[] a3 = new int[indices.length];
        int n = a2 = 0;
        while (n < indices.length) {
            a3[a2] = arr[indices[a2]];
            n = ++a2;
        }
        return a3;
    }

    public static int[] seq(int from, int to, int inc) {
        int a2 = (int)DoubleUtils.round((double)((to - from) / inc + 1), DoubleUtils.RoundingScheme.DOWN);
        int[] a3 = new int[a2];
        int a4 = 0;
        int a5 = from;
        do {
            a3[a4++] = a5;
        } while ((inc <= 0 || (a5 += inc) <= to) && (inc >= 0 || a5 >= to));
        return a3;
    }

    public static String paste(AbstractCollection<String> collection, String delimiter) {
        if (collection.isEmpty()) {
            return "";
        }
        Iterator<String> a2 = collection.iterator();
        StringBuilder a3 = new StringBuilder(a2.next());
        Iterator<String> iterator = a2;
        while (iterator.hasNext()) {
            a3.append(delimiter).append(a2.next());
            iterator = a2;
        }
        return a3.toString();
    }

    public static double[] subarray(double[] arr, int[] indices) {
        int a2;
        SuanShuUtils.assertArgument(arr.length > 0, "arr length > 0", new Object[0]);
        SuanShuUtils.assertArgument(indices.length > 0, "indices length > 0", new Object[0]);
        SuanShuUtils.assertArgument(arr.length >= indices.length, "too many indices", new Object[0]);
        double[] a3 = new double[indices.length];
        int n = a2 = 0;
        while (n < indices.length) {
            a3[a2] = arr[indices[a2]];
            n = ++a2;
        }
        return a3;
    }

    public static double[] seq(double from, double to, double inc) {
        int a2;
        int a3 = (int)DoubleUtils.round((to - from) / inc + 1.0, DoubleUtils.RoundingScheme.DOWN);
        double[] a4 = new double[a3];
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = from + (double)a2 * inc;
            n = ++a2;
        }
        return a4;
    }

    public static double[][] diff(double[][] arr) {
        return R.diff(arr, 1, 1);
    }

    public static double[][] diff(double[][] arr, int lag, int difference) {
        int a2;
        DenseMatrix a3 = new DenseMatrix(arr);
        double[][] a4 = new double[a3.nCols()][];
        int n = a2 = 1;
        while (n <= a3.nCols()) {
            a4[a2 - 1] = R.diff(a3.getColumn(a2).toArray(), lag, difference);
            n = ++a2;
        }
        DenseMatrix a22 = new DenseMatrix(a4);
        return MatrixUtils.to2DArray(a22.t());
    }

    public static int[] order(double[] arr, boolean ascending) {
        SuanShuUtils.assertArgument(arr.length > 0, "arr length > 0", new Object[0]);
        int[] a2 = DoubleUtils.shellsort(Arrays.copyOf(arr, arr.length));
        if (!ascending) {
            DoubleUtils.reverse(a2);
        }
        return a2;
    }

    public static double[] rep(double value, int times) {
        int a2;
        SuanShuUtils.assertArgument(times >= 0, "the number of repetitions must be a natural number", new Object[0]);
        double[] a3 = new double[times];
        int n = a2 = 0;
        while (n < times) {
            a3[a2] = value;
            n = ++a2;
        }
        return a3;
    }

    public static double[] diff(double[] arr, int lag, int difference) {
        int a2;
        SuanShuUtils.assertArgument(arr.length > 0, "arr length > 0", new Object[0]);
        SuanShuUtils.assertArgument(lag >= 1, "lag >= 1", new Object[0]);
        SuanShuUtils.assertArgument(difference >= 1, "difference >= 1", new Object[0]);
        double[] a3 = new double[arr.length - lag];
        int a4 = 0;
        int n = a2 = lag;
        while (n < arr.length) {
            a3[a4] = arr[a2] - arr[a4];
            ++a4;
            n = ++a2;
        }
        if (difference > 1) {
            return R.diff(a3, lag, difference - 1);
        }
        return a3;
    }

    public static double[] cumsum(double[] arr) {
        int a2;
        SuanShuUtils.assertArgument(arr.length > 0, "arr length > 0", new Object[0]);
        double[] dArray = new double[arr.length];
        double[] a3 = dArray;
        dArray[0] = arr[0];
        int n = a2 = 1;
        while (n < arr.length) {
            a3[a2] = a3[a2 - 1] + arr[a2];
            n = ++a2;
        }
        return a3;
    }

    public static int[] seq(int from, int to) {
        int a2 = from < to ? 1 : -1;
        return R.seq(from, to, a2);
    }

    public static double[] ifelse(double[] arr, ifelse selection) {
        int a2;
        double[] a3 = new double[arr.length];
        int n = a2 = 0;
        while (n < arr.length) {
            double a4 = arr[a2];
            a3[a2] = selection.test(a4) ? selection.yes(a4) : selection.no(a4);
            n = ++a2;
        }
        return a3;
    }

    public static int[] which(double[] arr, which criterion) {
        int a2;
        int a3;
        ArrayList<Integer> a4 = new ArrayList<Integer>();
        int n = a3 = 0;
        while (n < arr.length) {
            if (criterion.isTrue(arr[a3], a3)) {
                a4.add(a3);
            }
            n = ++a3;
        }
        int[] a22 = new int[a4.size()];
        int n2 = a2 = 0;
        while (n2 < a22.length) {
            a22[a2] = (Integer)a4.get(a2);
            n2 = ++a2;
        }
        return a22;
    }

    public static interface which {
        public boolean isTrue(double var1, int var3);
    }

    public static interface ifelse {
        public boolean test(double var1);

        public double no(double var1);

        public double yes(double var1);
    }
}

