/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.generic.Matrix;
import java.lang.reflect.Array;
import java.util.Arrays;

public class GenericMatrix<F extends Field<F>>
implements Matrix<GenericMatrix<F>, F> {
    private final int F;
    private final int k;
    private F[][] L;
    private final F E;

    @Override
    public void set(int row, int col, F value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.L[row - 1][col - 1] = value;
    }

    public GenericMatrix(F[][] data) {
        int a2;
        this.k = data.length;
        this.F = data[0].length;
        this.E = (Field)data[0][0].ZERO();
        int[] nArray = new int[2];
        nArray[0] = this.k;
        nArray[1] = this.F;
        this.L = (Field[][])Array.newInstance(this.E.getClass(), nArray);
        int n = a2 = 0;
        while (n < this.k) {
            int a3;
            if (data[a2].length != this.F) {
                this.L = null;
                throw new IllegalArgumentException("data is a jagged array");
            }
            int n2 = a3 = 0;
            while (n2 < this.F) {
                this.L[a2][a3] = data[a2][a3];
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    @Override
    public GenericMatrix<F> add(GenericMatrix<F> that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.k, this.F, (Field)this.E.ZERO());
        int n = a2 = 0;
        while (n < this.k) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.F) {
                a3.L[a2][a4] = (Field)this.L[a2][a4].add(that.L[a2][a4]);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericMatrix a2 = (GenericMatrix)obj;
        if (!DimensionCheck.isSameDimension(this, a2)) {
            return false;
        }
        if (!(this.L == a2.L || this.L != null && a2.L != null && this.b((Field[][])a2.L))) {
            return false;
        }
        return true;
    }

    @Override
    public GenericMatrix<F> multiply(GenericMatrix<F> that) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, that);
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.k, that.F, (Field)this.E.ZERO());
        int n = a2 = 0;
        while (n < this.k) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < that.F) {
                int a5;
                Field a6 = (Field)this.E.ZERO();
                int n3 = a5 = 0;
                while (n3 < this.F) {
                    Field a7 = (Field)this.L[a2][a5].multiply(that.L[a5][a4]);
                    a6 = a6.add(a7);
                    n3 = ++a5;
                }
                a3.L[a2][a4] = a6;
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 61 * a2 + this.k;
        a2 = 61 * a2 + this.F;
        a2 = 61 * a2 + Arrays.deepHashCode(this.L);
        a2 = 61 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    @Override
    public GenericMatrix<F> ZERO() {
        return new GenericMatrix<Field>(this.k, this.F, (Field)this.E.ZERO());
    }

    @Override
    public int nRows() {
        return this.k;
    }

    @Override
    public int nCols() {
        return this.F;
    }

    private boolean b(F[][] a2) {
        GenericMatrix a3;
        int a4;
        int n = a4 = 0;
        while (n < a3.k) {
            int a5;
            int n2 = a5 = 0;
            while (n2 < a3.F) {
                if (!a3.L[a4][a5].equals(a2[a4][a5])) {
                    return false;
                }
                n2 = ++a5;
            }
            n = ++a4;
        }
        return true;
    }

    @Override
    public GenericMatrix<F> minus(GenericMatrix<F> that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.k, this.F, (Field)this.E.ZERO());
        int n = a2 = 0;
        while (n < this.k) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.F) {
                a3.L[a2][a4] = (Field)this.L[a2][a4].minus(that.L[a2][a4]);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public GenericMatrix(int nRows, int nCols, F init) {
        int a2;
        this.k = nRows;
        this.F = nCols;
        this.E = init;
        int[] nArray = new int[2];
        nArray[0] = nRows;
        nArray[1] = nCols;
        this.L = (Field[][])Array.newInstance(init.getClass(), nArray);
        int n = a2 = 0;
        while (n < nRows) {
            int a3;
            int n2 = a3 = 0;
            while (n2 < nCols) {
                this.L[a2][a3] = init;
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    @Override
    public GenericMatrix<F> opposite() {
        int a2;
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.k, this.F, (Field)this.E.ZERO());
        int n = a2 = 0;
        while (n < this.k) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.F) {
                a3.L[a2][a4] = (Field)this.L[a2][a4].opposite();
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public GenericMatrix<F> scaled(F scalar) {
        int a2;
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.k, this.F, (Field)this.E.ZERO());
        int n = a2 = 0;
        while (n < this.k) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.F) {
                a3.L[a2][a4] = (Field)this.L[a2][a4].multiply(scalar);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.k;
        objectArray[1] = this.F;
        a3.append(String.format("%dx%d\n", objectArray));
        a3.append("\t");
        int n = a2 = 1;
        while (n <= this.F) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a2;
            a3.append(String.format("[,%d] ", objectArray2));
            n = ++a2;
        }
        a3.append("\n");
        int n2 = a2 = 1;
        while (n2 <= this.k) {
            int a4;
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = a2;
            a3.append(String.format("[%d,] ", objectArray3));
            int n3 = a4 = 1;
            while (n3 <= this.F) {
                Object[] objectArray4 = new Object[1];
                objectArray4[0] = this.get(a2, a4).toString();
                a3.append(String.format("%s, ", objectArray4));
                n3 = ++a4;
            }
            a3.append("\n");
            n2 = ++a2;
        }
        return a3.toString();
    }

    @Override
    public GenericMatrix<F> ONE() {
        int a2;
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.k, this.F, (Field)this.E.ZERO());
        int n = a2 = 0;
        while (n < this.k) {
            a3.L[a2][a2] = (Field)this.E.ONE();
            n = ++a2;
        }
        return a3;
    }

    @Override
    public F get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.L[row - 1][col - 1];
    }
}

