/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.doubles.MatrixTable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrixUtils;

public class MatrixUtils {
    public static double[] to1DArray(MatrixTable A) {
        int a2;
        if (A instanceof DenseMatrix) {
            return DenseMatrixUtils.to1DArray((DenseMatrix)A);
        }
        int a3 = A.nRows();
        int a4 = A.nCols();
        double[] a5 = new double[a3 * a4];
        int a6 = 0;
        int n = a2 = 1;
        while (n <= a3) {
            int a7;
            int n2 = a7 = 1;
            while (n2 <= a4) {
                a5[a6++] = A.get(a2, a7);
                n2 = ++a7;
            }
            n = ++a2;
        }
        return a5;
    }

    public static int[] colSums(MatrixTable A) {
        int a2;
        int[] a3 = new int[A.nCols()];
        int n = a2 = 1;
        while (n <= A.nCols()) {
            int a4;
            a3[a2 - 1] = 0;
            int n2 = a4 = 1;
            while (n2 <= A.nRows()) {
                int n3 = a2 - 1;
                a3[n3] = (int)((double)a3[n3] + A.get(a4, a2));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public static double[][] to2DArray(MatrixTable A) {
        int a2;
        if (A instanceof DenseMatrix) {
            return DenseMatrixUtils.to2DArray((DenseMatrix)A);
        }
        int a3 = A.nRows();
        int a4 = A.nCols();
        double[][] a5 = new double[a3][a4];
        int n = a2 = 1;
        while (n <= a3) {
            int a6;
            int n2 = a6 = 1;
            while (n2 <= a4) {
                a5[a2 - 1][a6 - 1] = A.get(a2, a6);
                n2 = ++a6;
            }
            n = ++a2;
        }
        return a5;
    }

    public static int[] rowSums(MatrixTable A) {
        int a2;
        int[] a3 = new int[A.nRows()];
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            a3[a2 - 1] = 0;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                int n3 = a2 - 1;
                a3[n3] = (int)((double)a3[n3] + A.get(a2, a4));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }
}

