/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.Basis;

public class Householder {
    private final Vector E;

    public static Matrix product(Householder[] Hs, int from, int to) {
        int a2 = Hs[from].generator().size();
        return Householder.product(Hs, from, to, a2, a2);
    }

    public static Matrix product(Householder[] hhs, int from, int to, int nRows, int nCols) {
        int a2;
        VectorList a3 = Basis.getBasis(nRows, nCols);
        Object a4 = R.seq(to, from);
        int a5 = ((int[])a4).length;
        int n = a2 = 0;
        while (n < a5) {
            int a6 = a4[a2];
            int a7 = a6;
            if (hhs[a7] != null) {
                int a8;
                int n2 = a8 = 0;
                while (n2 < nCols) {
                    a3.set(a8, hhs[a7].reflect((Vector)a3.get(a8)));
                    n2 = ++a8;
                }
            }
            n = ++a2;
        }
        a4 = CreateMatrix.cbind(a3);
        return a4;
    }

    public Matrix H() {
        DenseMatrix a2 = new DenseMatrix(this.E.size(), this.E.size()).ONE();
        DenseMatrix a3 = new DenseMatrix(this.E.toArray(), this.E.size(), 1);
        return a2.minus(a3.multiply(a3.t()).scaled(2.0));
    }

    public Householder(Vector generator) {
        double a2 = generator.norm();
        this.E = DoubleUtils.compare(a2, 0.0) == 0 ? new DenseVector(generator.size()) : generator.scaled(1.0 / a2);
    }

    public Vector generator() {
        return this.E.deepCopy();
    }

    public Vector reflect(Vector x) {
        return x.minus(this.E.scaled(2.0 * this.E.innerProduct(x)));
    }

    public static Context getContext(Vector x) {
        double a2;
        Vector a3 = new DenseVector(x.size());
        double a4 = x.norm();
        double d2 = a2 = x.get(1) > 0.0 ? -a4 : a4;
        if (DoubleUtils.compare(a2, 0.0) != 0) {
            Basis a5 = new Basis(x.size(), 1);
            a3 = x.minus(a5.scaled(a2));
        }
        return new Context(a3, a2);
    }

    public Matrix reflect(Matrix A) {
        int a2;
        VectorList a3 = new VectorList();
        int n = a2 = 1;
        while (n <= A.nCols()) {
            Vector a4 = A.getColumn(a2);
            a3.add(this.reflect(a4));
            n = ++a2;
        }
        return CreateMatrix.cbind(a3);
    }

    public Matrix reflectRows(Matrix A) {
        int a2;
        VectorList a3 = new VectorList();
        int n = a2 = 1;
        while (n <= A.nRows()) {
            Vector a4 = A.getRow(a2);
            a3.add(this.reflect(a4));
            n = ++a2;
        }
        return CreateMatrix.rbind(a3);
    }

    public static class Context {
        public final Vector generator;
        public final double lambda;

        public Context(Vector a2, double a3) {
            Context a4;
            a4.generator = a2;
            a4.lambda = a3;
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.lambda;
            objectArray[1] = this.generator.toString();
            return String.format("\u03bb=%f; [%s]", objectArray);
        }
    }
}

