/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ElementaryOperation {
    private DenseMatrix E;

    public void addRow(int row1, int row2, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.E.nCols()) {
            this.E.set(row1, a2, this.E.get(row1, a2) + scale * this.E.get(row2, a2));
            n = ++a2;
        }
    }

    public void swapRow(int row1, int row2) {
        int a2;
        Vector a3 = this.E.getRow(row1);
        int a4 = this.E.nCols();
        int n = a2 = 1;
        while (n <= a4) {
            this.E.set(row1, a2, this.E.get(row2, a2));
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= a4) {
            this.E.set(row2, a2, a3.get(a2));
            n2 = ++a2;
        }
    }

    public ElementaryOperation(int dim) {
        this(dim, dim);
    }

    public ElementaryOperation(int nRows, int nCols) {
        this.E = new DenseMatrix(nRows, nCols).ONE();
    }

    public void scaleColumn(int col, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.E.nRows()) {
            this.E.set(a2, col, scale * this.E.get(a2, col));
            n = ++a2;
        }
    }

    public double get(int row, int col) {
        return this.E.get(row, col);
    }

    public void scaleRow(int row, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.E.nCols()) {
            this.E.set(row, a2, scale * this.E.get(row, a2));
            n = ++a2;
        }
    }

    public void addColumn(int col1, int col2, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.E.nRows()) {
            this.E.set(a2, col1, this.E.get(a2, col1) + scale * this.E.get(a2, col2));
            n = ++a2;
        }
    }

    public String toString() {
        return this.E.toString();
    }

    public Matrix T() {
        return this.E.deepCopy();
    }

    public void swapColumn(int col1, int col2) {
        int a2;
        Vector a3 = this.E.getColumn(col1);
        int n = a2 = 1;
        while (n <= this.E.nRows()) {
            this.E.set(a2, col1, this.E.get(a2, col2));
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.E.nRows()) {
            this.E.set(a2, col2, a3.get(a2));
            n2 = ++a2;
        }
    }

    public ElementaryOperation(Matrix T2) {
        this.E = new DenseMatrix(T2);
    }
}

