/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary.SORSweep;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class SuccessiveOverrelaxationSolver
implements IterativeSolver {
    private final double E;

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), problem.getMaxIteration(), problem.getTolerance(), problem.getInitialGuess(), monitor);
    }

    public SuccessiveOverrelaxationSolver(double omega) {
        this.E = omega;
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, IterationMonitor a7) throws IterativeSolver.ConvergenceFailure {
        int a8;
        SuccessiveOverrelaxationSolver a9;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(a2), "A must be a square matrix", new Object[0]);
        SORSweep a10 = new SORSweep(a2, a3, a9.E);
        Vector a11 = a6;
        Vector a12 = a3.minus(a2.multiply(a11));
        boolean a13 = a5.isResidualSmall(a12.norm());
        int n = a8 = 0;
        int n2 = a4;
        while (n < n2 && !a13) {
            a7.addIterate(a11);
            a11 = a10.forward(a11);
            a12 = a3.minus(a2.multiply(a11));
            a13 = a5.isResidualSmall(a12.norm());
            n = ++a8;
            n2 = a4;
        }
        a7.addIterate(a11);
        if (!a13) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a11;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }
}

