/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class JacobiPreconditioner
implements Preconditioner {
    private final Vector E;

    public JacobiPreconditioner(Matrix A) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), "A must be a square matrix", new Object[0]);
        Vector a2 = CreateVector.diagonal(A);
        this.E = CreateVector.foreach(a2, new UnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double x) {
                return 1.0 / x;
            }
        });
    }

    @Override
    public Vector transposeSolve(Vector x) {
        return this.solve(x);
    }

    @Override
    public Vector solve(Vector x) {
        return x.multiply(this.E);
    }
}

