/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientSquaredSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public ConjugateGradientSquaredSolver() {
        this(50);
    }

    public ConjugateGradientSquaredSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        Vector a12 = a11.deepCopy();
        Vector a13 = a10.ZERO();
        Vector a14 = a10.ZERO();
        double a15 = a11.innerProduct(a12);
        boolean a16 = a5.isResidualSmall(a11.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a16) {
            ConjugateGradientSquaredSolver a17;
            a8.addIterate(a10);
            double a18 = a11.innerProduct(a12);
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<r, rTilde> = 0");
            }
            double a19 = a18 / a15;
            Vector a20 = a11.add(a14.scaled(a19));
            a13 = a20.add(a14.add(a13.scaled(a19)).scaled(a19));
            Vector a21 = a7.solve(a13);
            Vector a22 = a2.multiply(a21);
            double a23 = a22.innerProduct(a12);
            if (Double.compare(a23, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<vHat, rTilde> = 0");
            }
            double a24 = a18 / a23;
            a14 = a20.minus(a22.scaled(a24));
            Vector a25 = a20.add(a14);
            Vector a26 = a7.solve(a25);
            a10 = a10.add(a26.scaled(a24));
            Vector a27 = a2.multiply(a26);
            a11 = (a9 + 1) % a17.E != 0 ? a11.minus(a27.scaled(a24)) : a3.minus(a2.multiply(a10));
            a15 = a18;
            a16 = a5.isResidualSmall(a11.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a10);
        if (!a16) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a10;
    }
}

