/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientNormalErrorSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    public ConjugateGradientNormalErrorSolver() {
        this(50);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Matrix a10 = a2.t();
        Vector a11 = a6;
        Vector a12 = a3.minus(a2.multiply(a11));
        Vector a13 = a11.ZERO();
        double a14 = 1.0;
        boolean a15 = a5.isResidualSmall(a12.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a15) {
            ConjugateGradientNormalErrorSolver a16;
            a8.addIterate(a11);
            Vector a17 = a7.solve(a12);
            double a18 = a17.innerProduct(a12);
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<z, r> = 0");
            }
            double a19 = a18 / a14;
            a13 = a10.multiply(a17).add(a13.scaled(a19));
            Vector a20 = a2.multiply(a13);
            double a21 = a13.innerProduct(a13);
            if (Double.compare(a21, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<p, p> = 0");
            }
            double a22 = a18 / a21;
            a11 = a11.add(a13.scaled(a22));
            a12 = (a9 + 1) % a16.E != 0 ? a12.minus(a20.scaled(a22)) : a3.minus(a2.multiply(a11));
            a14 = a18;
            a15 = a5.isResidualSmall(a12.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a11);
        if (!a15) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a11;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    public ConjugateGradientNormalErrorSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }
}

