/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class BiconjugateGradientStabilizedSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int E;

    public BiconjugateGradientStabilizedSolver() {
        this(50);
    }

    private Vector b(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        int a9;
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        Vector a12 = a11.deepCopy();
        Vector a13 = a10.ZERO();
        Vector a14 = a10.ZERO();
        double a15 = 1.0;
        double a16 = 1.0;
        double a17 = 1.0;
        boolean a18 = a5.isResidualSmall(a11.norm());
        int n = a9 = 0;
        int n2 = a4;
        while (n < n2 && !a18) {
            BiconjugateGradientStabilizedSolver a19;
            a8.addIterate(a10);
            if (Double.compare(a17, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "omega = 0");
            }
            double a20 = a12.innerProduct(a11);
            if (Double.compare(a20, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<rTilde, r> = 0");
            }
            double a21 = a20 / a15 * (a16 / a17);
            Vector a22 = a7.solve(a13 = a11.add(a13.minus(a14.scaled(a17)).scaled(a21)));
            double a23 = a12.innerProduct(a14 = a2.multiply(a22));
            if (Double.compare(a23, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, "<rTilde, v> = 0");
            }
            a16 = a20 / a23;
            Vector a24 = a11.minus(a14.scaled(a16));
            a18 = a5.isResidualSmall(a24.norm());
            if (a18) {
                a10 = a10.add(a22.scaled(a16));
                break;
            }
            Vector a25 = a7.solve(a24);
            Vector a26 = a2.multiply(a25);
            a17 = a26.innerProduct(a24) / a26.innerProduct(a26);
            a10 = a10.add(a22.scaled(a16)).add(a25.scaled(a17));
            a11 = (a9 + 1) % a19.E != 0 ? a24.minus(a26.scaled(a17)) : a3.minus(a2.multiply(a10));
            a15 = a20;
            a18 = a5.isResidualSmall(a11.norm());
            n = ++a9;
            n2 = a4;
        }
        a8.addIterate(a10);
        if (!a18) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS, a4 + " exceeded");
        }
        return a10;
    }

    public BiconjugateGradientStabilizedSolver(int residualRefreshRate) {
        this.E = residualRefreshRate;
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.b(problem.A(), problem.b(), Math.min(problem.getMaxIteration(), problem.A().nCols()), problem.getTolerance(), problem.getInitialGuess(), problem.getLeftPreconditioner(), monitor);
    }

    @Override
    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }
}

