/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.AbstractSparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.Coordinates;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseElement;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LILSparseMatrix
extends AbstractSparseMatrix {
    private final SparseVector[] E;

    @Override
    public int dropTolerance(double tolerance) {
        int a2;
        int a3 = 0;
        SparseVector[] a4 = this.E;
        int a5 = this.E.length;
        int n = a2 = 0;
        while (n < a5) {
            SparseVector a6 = a4[a2];
            a3 += a6.dropTolerance(tolerance);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix scaled(double scalar) {
        int a2;
        if (scalar == 0.0) {
            return new LILSparseMatrix(this.nRows, this.nCols);
        }
        SparseVector[] a3 = new SparseVector[this.nRows];
        int n = a2 = 0;
        while (n < this.nRows) {
            a3[a2] = (SparseVector)this.E[a2].scaled(scalar);
            n = ++a2;
        }
        return new LILSparseMatrix(a3);
    }

    private LILSparseMatrix k(LILSparseMatrix a2) {
        int a3;
        LILSparseMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        SparseVector[] a5 = new SparseVector[a4.nRows];
        int n = a3 = 0;
        while (n < a4.nRows) {
            a5[a3] = a4.E[a3].add(a2.E[a3]);
            n = ++a3;
        }
        return new LILSparseMatrix(a5);
    }

    private LILSparseMatrix(SparseVector[] a2) {
        super(a2.length, a2[0].size());
        LILSparseMatrix a3;
        a3.E = a2;
    }

    @Override
    public LILSparseMatrix deepCopy() {
        return new LILSparseMatrix(this);
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.E[row - 1].set(col, value);
    }

    public LILSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        this(nRows, nCols);
        int a2;
        SuanShuUtils.assertArgument(rowIndices.length == columnIndices.length && rowIndices.length == values.length, "input arrays size mismatch", new Object[0]);
        int n = a2 = 0;
        while (n < values.length) {
            this.E[rowIndices[a2] - 1].set(columnIndices[a2], values[a2]);
            n = ++a2;
        }
    }

    private LILSparseMatrix m(LILSparseMatrix a2) {
        int a3;
        LILSparseMatrix a4;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)a4, a2);
        LILSparseMatrix a5 = (LILSparseMatrix)a2.t();
        SparseVector[] a6 = new SparseVector[a2.nCols];
        int n = a3 = 0;
        while (n < a2.nCols) {
            a6[a3] = a4.b(a5.E[a3]);
            n = ++a3;
        }
        return (LILSparseMatrix)new LILSparseMatrix(a6).t();
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows, this.nCols).ZERO();
        int a4 = 1;
        SparseVector[] a5 = this.E;
        int a6 = this.E.length;
        int n = a2 = 0;
        while (n < a6) {
            Iterator<SparseVector.Entry> a7;
            Iterator<SparseVector.Entry> iterator = a7 = a5[a2].iterator();
            while (iterator.hasNext()) {
                SparseVector.Entry a8 = a7.next();
                a3.set(a4, a8.index(), a8.value());
                iterator = a7;
            }
            ++a4;
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Vector getRow(int row) {
        DimensionCheck.throwIfInvalidRow(this, row);
        return new SparseVector(this.E[row - 1]);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.m((LILSparseMatrix)that);
        }
        return super.multiply(that);
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.b((LILSparseMatrix)that);
        }
        return super.minus(that);
    }

    @Override
    public Vector multiply(Vector v) {
        int a2;
        if (v instanceof SparseVector) {
            return this.b((SparseVector)v);
        }
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        double[] a3 = new double[this.nRows];
        int n = a2 = 0;
        while (n < this.nRows) {
            a3[a2] = this.E[a2].innerProduct(v);
            n = ++a2;
        }
        return new DenseVector(a3);
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.k((LILSparseMatrix)that);
        }
        return super.add(that);
    }

    @Override
    public List<SparseElement> getElementList() {
        int a2;
        ArrayList<SparseElement> a3 = new ArrayList<SparseElement>(this.nnz());
        int a4 = 0;
        int n = a2 = 1;
        while (n <= this.nRows) {
            Iterator<SparseVector.Entry> iterator = this.E[a2 - 1].iterator();
            while (iterator.hasNext()) {
                Iterator<SparseVector.Entry> a5;
                SparseVector.Entry a6 = a5.next();
                a3.add(a4++, new SparseElement(new Coordinates(a2, a6.index()), a6.value()));
                iterator = a5;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Vector getColumn(int col) {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        SparseVector a3 = new SparseVector(this.nRows);
        int n = a2 = 1;
        while (n <= this.nRows) {
            double a4 = this.get(a2, col);
            if (Double.compare(0.0, a4) != 0) {
                a3.set(a2, a4);
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix ONE() {
        int a2 = Math.min(this.nRows, this.nCols);
        double[] a3 = R.rep(1.0, a2);
        int[] a4 = R.seq(1, a2);
        int[] a5 = R.seq(1, a2);
        return new LILSparseMatrix(this.nRows, this.nCols, a4, a5, a3);
    }

    public LILSparseMatrix(LILSparseMatrix that) {
        super(that.nRows, that.nCols);
        int a2;
        this.E = new SparseVector[this.nRows];
        int n = a2 = 0;
        while (n < this.nRows) {
            this.E[a2] = new SparseVector(that.E[a2]);
            n = ++a2;
        }
    }

    @Override
    public Matrix ZERO() {
        return new LILSparseMatrix(this.nRows, this.nCols);
    }

    private SparseVector b(SparseVector a2) {
        int a3;
        LILSparseMatrix a4;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)a4, a2);
        SparseVector a5 = new SparseVector(a4.nRows);
        double a6 = 0.0;
        int n = a3 = 0;
        while (n < a4.nRows) {
            a6 = a4.E[a3].innerProduct(a2);
            if (Double.compare(0.0, a6) != 0) {
                a5.set(a3 + 1, a6);
            }
            n = ++a3;
        }
        return a5;
    }

    public LILSparseMatrix(int nRows, int nCols, List<SparseElement> elementList) {
        this(nRows, nCols);
        Iterator<SparseElement> a2;
        Collections.sort(elementList, SparseElement.TopLeftFirstComparator.INSTANCE);
        Iterator<SparseElement> iterator = a2 = elementList.iterator();
        while (iterator.hasNext()) {
            SparseElement a3 = a2.next();
            this.E[a3.coordinates.i - 1].set(a3.coordinates.j, a3.value);
            iterator = a2;
        }
    }

    public LILSparseMatrix(int nRows, int nCols) {
        super(nRows, nCols);
        int a2;
        this.E = new SparseVector[nRows];
        int n = a2 = 0;
        while (n < nRows) {
            this.E[a2] = new SparseVector(nCols);
            n = ++a2;
        }
    }

    @Override
    public int nnz() {
        int a2;
        int a3 = 0;
        SparseVector[] a4 = this.E;
        int a5 = this.E.length;
        int n = a2 = 0;
        while (n < a5) {
            SparseVector a6 = a4[a2];
            a3 += a6.nnz();
            n = ++a2;
        }
        return a3;
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.E[row - 1].get(col);
    }

    @Override
    public Matrix t() {
        int a2;
        LILSparseMatrix a3 = new LILSparseMatrix(this.nCols, this.nRows);
        int n = a2 = 0;
        while (n < this.nRows) {
            Iterator<SparseVector.Entry> iterator = this.E[a2].iterator();
            while (iterator.hasNext()) {
                Iterator<SparseVector.Entry> a4;
                SparseVector.Entry a5 = a4.next();
                a3.set(a5.index(), a2 + 1, a5.value());
                iterator = a4;
            }
            n = ++a2;
        }
        return a3;
    }

    private LILSparseMatrix b(LILSparseMatrix a2) {
        int a3;
        LILSparseMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        SparseVector[] a5 = new SparseVector[a4.nRows];
        int n = a3 = 0;
        while (n < a4.nRows) {
            a5[a3] = a4.E[a3].minus(a2.E[a3]);
            n = ++a3;
        }
        return new LILSparseMatrix(a5);
    }
}

