/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.AbstractSparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.Coordinates;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.LILSparseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseElement;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CSRSparseMatrix
extends AbstractSparseMatrix {
    private int F;
    private double[] k;
    private int[] L;
    private int[] E;

    @Override
    public Matrix t() {
        int a2;
        CSRSparseMatrix a3 = new CSRSparseMatrix(this.nCols, this.nRows, false);
        double[] a4 = new double[this.k.length];
        int[] a5 = new int[this.L.length];
        int[] a6 = new int[this.nCols + 1];
        int n = a2 = 0;
        while (n < this.L.length) {
            int n2 = this.L[a2];
            a6[n2] = a6[n2] + 1;
            n = ++a2;
        }
        a6 = R.cumsum(a6);
        a3.E = (int[])a6.clone();
        int n3 = a2 = 1;
        while (n3 <= this.nRows) {
            int n4 = this.E[a2 - 1];
            while (n4 < this.E[a2]) {
                int a7;
                int n5 = this.L[a7] - 1;
                a6[n5] = a6[n5] + 1;
                a5[a] = a2;
                a4[a] = this.k[a7];
                n4 = ++a7;
            }
            n3 = ++a2;
        }
        a3.k = a4;
        a3.L = a5;
        return a3;
    }

    @Override
    public Matrix ONE() {
        int a2 = Math.min(this.nRows, this.nCols);
        double[] a3 = R.rep(1.0, a2);
        int[] a4 = R.seq(1, a2);
        int[] a5 = R.seq(1, a2);
        return new CSRSparseMatrix(this.nRows, this.nCols, a4, a5, a3);
    }

    private void b(CheckForKeepValue a2) {
        CSRSparseMatrix a3;
        int a4;
        int a5 = 0;
        int n = a4 = 0;
        while (n < a3.nRows) {
            int a6 = a3.E[a4];
            a3.E[a4] = a5;
            int n2 = a6;
            while (true) {
                if (n2 >= a3.E[a4 + 1]) break;
                if (a2.toKeep(a3.k[a6])) {
                    a3.k[a5] = a3.k[a6];
                    a3.L[a5] = a3.L[a6];
                    ++a5;
                }
                n2 = ++a6;
            }
            n = ++a4;
        }
        a3.E[a3.nRows] = a5;
        a3.k = Arrays.copyOf(a3.k, a5);
        a3.L = Arrays.copyOf(a3.L, a5);
        a3.F = a5;
    }

    @Override
    public Vector multiply(Vector v) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        Vector a3 = v instanceof SparseVector ? new SparseVector(this.nRows) : new DenseVector(this.nRows);
        int n = a2 = 1;
        while (n <= this.nRows) {
            a3.set(a2, this.getRow(a2).innerProduct(v));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.b((CSRSparseMatrix)that, 1.0);
        }
        return super.add(that);
    }

    @Override
    public Vector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        SparseVector a3 = new SparseVector(this.nCols);
        int n = a2 = this.E[row - 1];
        while (n < this.E[row]) {
            a3.set(this.L[a2], this.k[a2]);
            n = ++a2;
        }
        return a3;
    }

    private CSRSparseMatrix b(CSRSparseMatrix a2) {
        int a3;
        CSRSparseMatrix a4;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)a4, a2);
        CSRSparseMatrix a5 = new CSRSparseMatrix(a4.nRows, a2.nCols, false);
        new CSRSparseMatrix(a4.nRows, a2.nCols, false).E = new int[a4.nRows + 1];
        double[] a6 = new double[a4.nnz() + a2.nnz()];
        int[] a7 = new int[a4.nnz() + a2.nnz()];
        int a8 = 0;
        Scatter a9 = new Scatter(a2.nCols, null);
        int n = a3 = 1;
        while (n <= a4.nRows) {
            if (a8 + a2.nCols > a6.length) {
                a6 = Arrays.copyOf(a6, 2 * a6.length + a2.nCols);
                a7 = Arrays.copyOf(a7, 2 * a7.length + a2.nCols);
            }
            a5.E[a3 - 1] = a8;
            a9.b(a3);
            int n2 = a4.E[a3 - 1];
            while (n2 < a4.E[a3]) {
                int a10;
                a9.b(a2, a4.L[a10], a4.k[a10]);
                n2 = ++a10;
            }
            a8 += a9.b(a6, a7, a8);
            n = ++a3;
        }
        a5.E[a4.nRows] = a8;
        a5.F = a8;
        a5.k = Arrays.copyOf(a6, a8);
        a5.L = Arrays.copyOf(a7, a8);
        a5.m();
        a5.b();
        return a5;
    }

    public CSRSparseMatrix(CSRSparseMatrix that) {
        super(that.nRows, that.nCols);
        this.F = 0;
        this.E = null;
        this.L = null;
        this.k = null;
        this.F = that.F;
        this.k = (double[])that.k.clone();
        this.L = (int[])that.L.clone();
        this.E = (int[])that.E.clone();
    }

    @Override
    public int nnz() {
        return this.F;
    }

    public CSRSparseMatrix(int nRows, int nCols, List<SparseElement> elementList) {
        super(nRows, nCols);
        Iterator<SparseElement> a2;
        this.F = 0;
        this.E = null;
        this.L = null;
        this.k = null;
        Collections.sort(elementList, SparseElement.TopLeftFirstComparator.INSTANCE);
        this.F = elementList.size();
        this.k = new double[this.F];
        this.L = new int[this.F];
        int[] a3 = new int[nRows + 1];
        int a4 = 0;
        Iterator<SparseElement> iterator = a2 = elementList.iterator();
        while (iterator.hasNext()) {
            SparseElement a5;
            block4: {
                block3: {
                    a5 = a2.next();
                    Coordinates a6 = a5.coordinates;
                    if (a6.i < 1 || a6.i > nRows) break block3;
                    if (a6.j >= 1 && a6.j <= nCols) break block4;
                }
                throw new IllegalArgumentException("out-of-range element coordinates");
            }
            this.k[a4] = a5.value;
            this.L[a4] = a5.coordinates.j;
            ++a4;
            int n = a5.coordinates.i;
            a3[n] = a3[n] + 1;
            iterator = a2;
        }
        this.E = R.cumsum(a3);
    }

    @Override
    public List<SparseElement> getElementList() {
        int a2;
        ArrayList<SparseElement> a3 = new ArrayList<SparseElement>(this.nnz());
        int n = a2 = 1;
        while (n <= this.nRows) {
            int n2 = this.E[a2 - 1];
            while (n2 < this.E[a2]) {
                int a4;
                a3.add(new SparseElement(new Coordinates(a2, this.L[a4]), this.k[a4]));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public int dropTolerance(final double tolerance) {
        int a2 = this.F;
        this.b(new CheckForKeepValue(){
            {
                1 a2;
            }

            @Override
            public boolean toKeep(double value) {
                return Double.compare(Math.abs(value), tolerance) > 0;
            }
        });
        return a2 - this.F;
    }

    private void m() {
        CSRSparseMatrix a2;
        a2.b(new CheckForKeepValue(){
            {
                2 a2;
            }

            @Override
            public boolean toKeep(double value) {
                return Double.compare(0.0, value) != 0;
            }
        });
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = this.E[row - 1];
        int a3 = this.E[row];
        int a4 = 0;
        int n = a4 = a2;
        while (n < a3 && this.L[a4] < col) {
            n = ++a4;
        }
        if (a4 != a3 && this.L[a4] == col) {
            if (value != 0.0) {
                this.k[a4] = value;
            } else {
                int a5;
                double[] a6 = this.k;
                this.k = new double[a6.length - 1];
                System.arraycopy(a6, 0, this.k, 0, a4);
                System.arraycopy(a6, a4 + 1, this.k, a4, this.k.length - a4);
                int[] a7 = this.L;
                this.L = new int[a7.length - 1];
                System.arraycopy(a7, 0, this.L, 0, a4);
                System.arraycopy(a7, a4 + 1, this.L, a4, this.L.length - a4);
                int n2 = a5 = row;
                while (n2 < this.E.length) {
                    int n3 = a5++;
                    this.E[n3] = this.E[n3] - 1;
                    n2 = a5;
                }
                --this.F;
            }
        } else {
            int a8;
            double[] a9 = this.k;
            this.k = new double[a9.length + 1];
            System.arraycopy(a9, 0, this.k, 0, a4);
            System.arraycopy(a9, a4, this.k, a4 + 1, a9.length - a4);
            this.k[a4] = value;
            int[] a10 = this.L;
            this.L = new int[a10.length + 1];
            System.arraycopy(a10, 0, this.L, 0, a4);
            System.arraycopy(a10, a4, this.L, a4 + 1, a10.length - a4);
            this.L[a4] = col;
            int n4 = a8 = row;
            while (n4 < this.E.length) {
                int n5 = a8++;
                this.E[n5] = this.E[n5] + 1;
                n4 = a8;
            }
            ++this.F;
        }
    }

    private CSRSparseMatrix(int a2, int a3, boolean a4) {
        super(a2, a3);
        CSRSparseMatrix a5;
        a5.F = 0;
        a5.E = null;
        a5.L = null;
        a5.k = null;
        a5.F = 0;
        if (a4) {
            a5.k = new double[0];
            a5.L = new int[0];
            a5.E = new int[a2 + 1];
        }
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.b((CSRSparseMatrix)that, -1.0);
        }
        return super.minus(that);
    }

    private void b() {
        CSRSparseMatrix a2;
        a2.t().t();
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = this.E[row - 1];
        int a3 = this.E[row];
        int a4 = 0;
        int n = a4 = a2;
        while (n < a3 && this.L[a4] != col) {
            n = ++a4;
        }
        return a4 == a3 ? 0.0 : this.k[a4];
    }

    @Override
    public CSRSparseMatrix deepCopy() {
        return new CSRSparseMatrix(this);
    }

    public CSRSparseMatrix(int nRows, int nCols) {
        this(nRows, nCols, true);
    }

    @Override
    public Matrix scaled(double scalar) {
        int a2;
        if (Double.compare(0.0, scalar) == 0) {
            return new CSRSparseMatrix(this.nRows, this.nCols);
        }
        CSRSparseMatrix a3 = new CSRSparseMatrix(this);
        int n = a2 = 0;
        while (n < a3.k.length) {
            int n2 = a2++;
            a3.k[n2] = a3.k[n2] * scalar;
            n = a2;
        }
        return a3;
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows, this.nCols);
        int n = a2 = 1;
        while (n <= this.nRows) {
            int n2 = this.E[a2 - 1];
            while (n2 < this.E[a2]) {
                int a4;
                a3.set(a2, this.L[a4], this.k[a4]);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix ZERO() {
        return new CSRSparseMatrix(this.nRows, this.nCols);
    }

    private CSRSparseMatrix b(CSRSparseMatrix a2, double a3) {
        int a4;
        CSRSparseMatrix a5;
        DimensionCheck.throwIfDifferentDimension(a5, a2);
        CSRSparseMatrix a6 = new CSRSparseMatrix(a5.nRows, a5.nCols, false);
        new CSRSparseMatrix(a5.nRows, a5.nCols, false).E = new int[a5.nRows + 1];
        double[] a7 = new double[a5.nnz() + a2.nnz()];
        int[] a8 = new int[a5.nnz() + a2.nnz()];
        int a9 = 0;
        Scatter a10 = new Scatter(a5.nCols, null);
        int n = a4 = 1;
        while (n <= a5.nRows) {
            a6.E[a4 - 1] = a9;
            a10.b(a4);
            a10.b(a5, a4, 1.0);
            a10.b(a2, a4, a3);
            a9 += a10.b(a7, a8, a9);
            n = ++a4;
        }
        a6.E[a5.nRows] = a9;
        a6.F = a9;
        a6.k = Arrays.copyOf(a7, a9);
        a6.L = Arrays.copyOf(a8, a9);
        a6.m();
        a6.b();
        return a6;
    }

    @Override
    public Vector getColumn(int col) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidColumn(this, col);
        SparseVector a3 = new SparseVector(this.nRows);
        int n = a2 = 1;
        while (n <= this.nRows) {
            int n2 = this.E[a2 - 1];
            while (n2 < this.E[a2]) {
                int a4;
                if (this.L[a4] == col) {
                    a3.set(a2, this.k[a4]);
                }
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.b((CSRSparseMatrix)that);
        }
        return super.multiply(that);
    }

    public CSRSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        super(nRows, nCols);
        int a2;
        this.F = 0;
        this.E = null;
        this.L = null;
        this.k = null;
        SuanShuUtils.assertArgument(rowIndices.length == columnIndices.length && rowIndices.length == values.length, "input arrays size mismatch", new Object[0]);
        this.F = values.length;
        this.k = new double[values.length];
        this.L = new int[values.length];
        this.E = new int[nRows + 1];
        LILSparseMatrix a3 = new LILSparseMatrix(nRows, nCols, rowIndices, columnIndices, values);
        this.E[0] = 0;
        SparseVector a4 = null;
        int a5 = 0;
        int n = a2 = 1;
        while (n <= nRows) {
            a4 = (SparseVector)a3.getRow(a2);
            Iterator<SparseVector.Entry> iterator = a4.iterator();
            while (iterator.hasNext()) {
                Iterator<SparseVector.Entry> a6;
                SparseVector.Entry a7 = a6.next();
                this.k[a5] = a7.value();
                this.L[a5] = a7.index();
                ++a5;
                iterator = a6;
            }
            this.E[a2] = a5;
            n = ++a2;
        }
    }

    private static interface CheckForKeepValue {
        public boolean toKeep(double var1);
    }

    private static class Scatter {
        private final int[] G;
        private double[] F;
        private int[] k;
        private int L;
        private int E;

        private Scatter(int a2) {
            Scatter a3;
            a3.G = new int[a2];
            a3.k = new int[a2];
            a3.F = new double[a2];
        }

        private void b(int a2) {
            Scatter a3;
            a3.E = a2;
            Arrays.fill(a3.k, 0, a3.L, 0);
            a3.L = 0;
        }

        public /* synthetic */ Scatter(int a2, 1 a3) {
            a4(a2);
            Scatter a4;
        }

        private int b(double[] a2, int[] a3, int a4) {
            int a5;
            Scatter a6;
            System.arraycopy(a6.k, 0, a3, a4, a6.L);
            int n = a5 = 0;
            while (n < a6.L) {
                a2[a4 + a5] = a6.F[a6.k[a5] - 1];
                n = ++a5;
            }
            return a6.L;
        }

        private void b(CSRSparseMatrix a2, int a3, double a4) {
            int a5;
            int n = a5 = a2.E[a3 - 1];
            while (n < a2.E[a3]) {
                Scatter a6;
                int a7 = a2.L[a5];
                if (a6.G[a7 - 1] < a6.E) {
                    a6.G[a7 - 1] = a6.E;
                    int n2 = a6.L;
                    a6.L = n2 + 1;
                    a6.k[n2] = a7;
                    a6.F[a7 - 1] = 0.0;
                }
                int n3 = a7 - 1;
                a6.F[n3] = a6.F[n3] + a4 * a2.k[a5];
                n = ++a5;
            }
        }
    }
}

