/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseElement;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractSparseMatrix
implements SparseMatrix {
    public final int nRows;
    private final MatrixMathOperation E;
    public final int nCols;

    @Override
    public Matrix scaled(double scalar) {
        return this.E.scaled(this, scalar);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 79 * a2 + this.nRows;
        a2 = 79 * a2 + this.nCols;
        return a2;
    }

    @Override
    public Matrix t() {
        return this.E.transpose(this);
    }

    @Override
    public Matrix add(Matrix that) {
        return this.E.add(this, that);
    }

    @Override
    public Vector multiply(Vector v) {
        return this.E.multiply((Matrix)this, v);
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.E.multiply((Matrix)this, that);
    }

    public String toString() {
        Iterator<SparseElement> a2;
        List<SparseElement> a3 = this.getElementList();
        StringBuilder a4 = new StringBuilder();
        a4.append(this.nRows).append("x").append(this.nCols).append(" nnz = ").append(this.nnz()).append("\n");
        Iterator<SparseElement> iterator = a2 = a3.iterator();
        while (iterator.hasNext()) {
            SparseElement a5 = a2.next();
            a4.append("(").append(a5.coordinates.i).append(", ").append(a5.coordinates.j).append("): ").append(a5.value).append("\n");
            iterator = a2;
        }
        return a4.toString();
    }

    @Override
    public int nCols() {
        return this.nCols;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSparseMatrix a2 = (AbstractSparseMatrix)obj;
        if (this.nRows != a2.nRows) {
            return false;
        }
        if (this.nCols != a2.nCols) {
            return false;
        }
        if (this.nnz() != a2.nnz()) {
            return false;
        }
        List<SparseElement> a3 = this.getElementList();
        List<SparseElement> a4 = a2.getElementList();
        Collections.sort(a3, SparseElement.TopLeftFirstComparator.INSTANCE);
        Collections.sort(a4, SparseElement.TopLeftFirstComparator.INSTANCE);
        ListIterator<SparseElement> a5 = a3.listIterator();
        ListIterator<SparseElement> a6 = a4.listIterator();
        boolean a7 = a5.hasNext();
        boolean a8 = a6.hasNext();
        boolean bl = a7;
        while (bl && a8) {
            if (!((SparseElement)a5.next()).equals(a6.next())) {
                return false;
            }
            a7 = a5.hasNext();
            a8 = a6.hasNext();
            bl = a7;
        }
        if (a7 != a8) {
            return false;
        }
        return true;
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.E.minus(this, that);
    }

    @Override
    public int nRows() {
        return this.nRows;
    }

    public AbstractSparseMatrix(int a2, int a3) {
        block3: {
            block2: {
                AbstractSparseMatrix a4;
                a4.E = new SimpleMatrixMathOperation();
                if (a2 < 1) break block2;
                if (a3 >= 1) break block3;
            }
            throw new IllegalArgumentException("matrix dimension must be positive");
        }
        a4.nRows = a2;
        a4.nCols = a3;
    }
}

