/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.parallel.LoopBody;
import com.numericalmethod.suanshu.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class ParallelMatrixMathOperation
implements MatrixMathOperation {
    private final ParallelExecutor E = new ParallelExecutor();

    @Override
    public Matrix add(final Matrix A1, final Matrix A2) {
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        final DenseMatrix a2 = new DenseMatrix(A1.nRows(), A1.nCols());
        a2.set(1, 1, 0.0);
        try {
            this.E.forLoop(1, A1.nRows() + 1, new LoopBody(){
                {
                    1 a22;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a22;
                    int n = a22 = 1;
                    while (n <= A1.nCols()) {
                        a2.set(i2, a22, A1.get(i2, a22) + A2.get(i2, a22));
                        n = ++a22;
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    public ParallelMatrixMathOperation() {
        ParallelMatrixMathOperation a2;
    }

    @Override
    public Matrix transpose(final Matrix A) {
        final DenseMatrix a2 = new DenseMatrix(A.nCols(), A.nRows());
        a2.set(1, 1, 0.0);
        try {
            this.E.forLoop(1, A.nCols() + 1, new LoopBody(){
                {
                    6 a22;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a22;
                    int n = a22 = 1;
                    while (n <= A.nRows()) {
                        a2.set(i2, a22, A.get(a22, i2));
                        n = ++a22;
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Matrix scaled(final Matrix A, final double scalar) {
        final DenseMatrix a2 = new DenseMatrix(A.nRows(), A.nCols());
        a2.set(1, 1, 0.0);
        try {
            this.E.forLoop(1, A.nRows() + 1, new LoopBody(){
                {
                    5 a22;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a22;
                    int n = a22 = 1;
                    while (n <= A.nCols()) {
                        a2.set(i2, a22, A.get(i2, a22) * scalar);
                        n = ++a22;
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Matrix multiply(final Matrix A1, final Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A1, A2);
        final DenseMatrix a2 = new DenseMatrix(A1.nRows(), A2.nCols());
        a2.set(1, 1, 0.0);
        try {
            this.E.forLoop(1, a2.nRows() + 1, new LoopBody(){
                {
                    3 a22;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a22;
                    int n = a22 = 1;
                    while (n <= a2.nCols()) {
                        int a3;
                        double a4 = 0.0;
                        int n2 = a3 = 1;
                        while (n2 <= A1.nCols()) {
                            a4 += A1.get(i2, a3) * A2.get(a3, a22);
                            n2 = ++a3;
                        }
                        a2.set(i2, a22, a4);
                        n = ++a22;
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Matrix minus(final Matrix A1, final Matrix A2) {
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        final DenseMatrix a2 = new DenseMatrix(A1.nRows(), A1.nCols());
        a2.set(1, 1, 0.0);
        try {
            this.E.forLoop(1, A1.nRows() + 1, new LoopBody(){
                {
                    2 a22;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a22;
                    int n = a22 = 1;
                    while (n <= A1.nCols()) {
                        a2.set(i2, a22, A1.get(i2, a22) - A2.get(i2, a22));
                        n = ++a22;
                    }
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }

    @Override
    public Vector multiply(final Matrix A, final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)A, v);
        final DenseVector a2 = new DenseVector(A.nRows());
        try {
            this.E.forLoop(1, a2.length + 1, new LoopBody(){
                {
                    4 a22;
                }

                @Override
                public void run(int i2) throws Exception {
                    int a22;
                    double a3 = 0.0;
                    int n = a22 = 1;
                    while (n <= v.size()) {
                        a3 += A.get(i2, a22) * v.get(a22);
                        n = ++a22;
                    }
                    a2.set(i2, a3);
                }
            });
        }
        catch (MultipleExecutionException a3) {
            throw new RuntimeException(a3);
        }
        return a2;
    }
}

