/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.TriangularData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.TriangularMatrix;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class UpperTriangularMatrix
extends TriangularMatrix<UpperTriangularMatrix>
implements Densifiable {
    @Override
    public UpperTriangularMatrix ZERO() {
        return new UpperTriangularMatrix(this.dim());
    }

    @Override
    public DenseVector getColumn(int col) {
        if (col < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (col > this.nCols()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = this.getDataArray();
        double[] a3 = new double[this.nRows()];
        int a4 = 0;
        int a5 = col - 1;
        int n = a4;
        while (n < col) {
            a3[a4] = a2[a5];
            a5 += this.nCols() - ++a4;
            n = a4;
        }
        return new DenseVector(a3);
    }

    @Override
    public UpperTriangularMatrix multiply(UpperTriangularMatrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        TriangularData a3 = this.getMatrixData();
        TriangularData a4 = that.getMatrixData();
        MyDenseDataImpl a5 = new MyDenseDataImpl(this.dim());
        int n = a2 = 1;
        while (n <= this.dim()) {
            int n2 = a2;
            while (n2 <= this.dim()) {
                int a6;
                double a7 = 0.0;
                int n3 = a2;
                while (n3 <= a6) {
                    int a8;
                    a7 += a3.get(a2, a8) * a4.get(a8, a6);
                    n3 = ++a8;
                }
                a5.set(a2, a6, a7);
                n2 = ++a6;
            }
            n = ++a2;
        }
        return new UpperTriangularMatrix(a5);
    }

    public UpperTriangularMatrix(UpperTriangularMatrix U) {
        this((MyDenseDataImpl)U.getMatrixData().deepCopy());
    }

    @Override
    public DenseVector getRow(int row) {
        if (row < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (row > this.nRows()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = new double[this.nCols()];
        int a3 = (row - 1) * this.nCols();
        if (row >= 3) {
            a3 -= (row - 1) * (row - 2) >> 1;
        }
        int a4 = row - 1;
        int a5 = this.nCols() - a4;
        System.arraycopy(this.getDataArray(), a3, a2, a4, a5);
        return new DenseVector(a2);
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        double[] a3 = this.getDataArray();
        double[] a4 = new double[this.nRows() * this.nCols()];
        int a5 = 0;
        int a6 = 1;
        int n = a2 = 0;
        while (n < a4.length) {
            int a7;
            int n2 = a7 = 0;
            while (n2 <= this.nCols() - a6) {
                a4[a2 + a7] = a3[a5++];
                n2 = ++a7;
            }
            ++a6;
            n = a2 += this.nCols() + 1;
        }
        return new DenseMatrix(a4, this.nRows(), this.nCols());
    }

    @Override
    public UpperTriangularMatrix add(UpperTriangularMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        return new UpperTriangularMatrix(new MyDenseDataImpl(this.getMatrixData().add(that.getMatrixData())));
    }

    @Override
    public UpperTriangularMatrix minus(UpperTriangularMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        return new UpperTriangularMatrix(new MyDenseDataImpl(this.getMatrixData().minus(that.getMatrixData())));
    }

    private UpperTriangularMatrix(MyDenseDataImpl a2) {
        super(a2);
        UpperTriangularMatrix a3;
    }

    public UpperTriangularMatrix(double[][] data) {
        this(data[0].length);
        int a2;
        int n = a2 = 1;
        while (n <= this.dim()) {
            if (data[a2 - 1].length != this.dim() - a2 + 1) {
                throw new IllegalArgumentException("data set is not upper triangular");
            }
            int n2 = a2;
            while (n2 <= this.dim()) {
                int a3;
                this.set(a2, a3, data[a2 - 1][a3 - a2]);
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public UpperTriangularMatrix(Matrix U) {
        this(U.nRows());
        int a2;
        if (!DimensionCheck.isSquare(U)) {
            throw new IllegalArgumentException("a upper triangular matrix must be square");
        }
        int n = a2 = 1;
        while (n <= this.dim()) {
            int n2 = a2;
            while (n2 <= this.dim()) {
                int a3;
                this.set(a2, a3, U.get(a2, a3));
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public UpperTriangularMatrix(int dim) {
        this(new MyDenseDataImpl(dim));
    }

    @Override
    public UpperTriangularMatrix scaled(double scalar) {
        return new UpperTriangularMatrix(new MyDenseDataImpl(this.getMatrixData().scaled(scalar)));
    }

    @Override
    public UpperTriangularMatrix ONE() {
        int a2;
        UpperTriangularMatrix a3 = new UpperTriangularMatrix(this.dim());
        int n = a2 = 1;
        while (n <= this.dim()) {
            a3.set(a2, a2, 1.0);
            n = ++a2;
        }
        return a3;
    }

    @Override
    public UpperTriangularMatrix deepCopy() {
        return new UpperTriangularMatrix(this);
    }

    @Override
    public LowerTriangularMatrix t() {
        int a2;
        LowerTriangularMatrix a3 = new LowerTriangularMatrix(this.dim());
        double[] a4 = a3.getDataArray();
        double[] a5 = this.getDataArray();
        int a6 = 0;
        int n = a2 = 0;
        while (n < this.nCols()) {
            int a7 = 0;
            int a8 = 0;
            int n2 = a7;
            while (n2 <= a2) {
                a4[a6++] = a5[a2 + a8];
                a8 += this.nRows() - ++a7;
                n2 = a7;
            }
            n = ++a2;
        }
        return a3;
    }

    private static class MyDenseDataImpl
    extends TriangularData {
        @Override
        public void set(int row, int col, double value) {
            if (row > col) {
                return;
            }
            int a2 = row == 1 ? col - 1 : (row - 1) * this.dim - ((row - 1) * (row - 2) >> 1) + col - row;
            this.data[a2] = value;
        }

        public MyDenseDataImpl(double[] a2) {
            super(a2);
            MyDenseDataImpl a3;
        }

        @Override
        public MyDenseDataImpl deepCopy() {
            return new MyDenseDataImpl(Arrays.copyOf(this.getDataArray(), this.getDataArray().length));
        }

        @Override
        public double get(int row, int col) {
            if (row <= col) {
                int a2 = row == 1 ? col - 1 : (row - 1) * this.dim - ((row - 1) * (row - 2) >> 1) + col - row;
                return this.data[a2];
            }
            return 0.0;
        }

        public MyDenseDataImpl(int a2) {
            super(a2);
            MyDenseDataImpl a3;
        }
    }
}

