/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.MatrixAccessor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixStorageImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class SymmetricMatrix
extends MatrixStorageImpl<SymmetricMatrix>
implements Densifiable {
    public final int dim;
    private LowerTriangularMatrix E;

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (row < col) {
            this.E.set(col, row, value);
        } else {
            this.E.set(row, col, value);
        }
    }

    @Override
    public SymmetricMatrix add(SymmetricMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).E = this.E.add(that.E);
        return a2;
    }

    @Override
    public double get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (row < col) {
            return this.E.get(col, row);
        }
        return this.E.get(row, col);
    }

    @Override
    public SymmetricMatrix ZERO() {
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).E = this.E.ZERO();
        return a2;
    }

    @Override
    public SymmetricMatrix t() {
        return this;
    }

    private SymmetricMatrix(LowerTriangularMatrix a2) {
        super(a2.dim(), a2.dim(), a2.getMatrixData());
        SymmetricMatrix a3;
        a3.dim = a2.dim();
        a3.E = a2;
    }

    @Override
    public int hashCode() {
        int a2 = 3;
        a2 = 17 * a2 + this.dim;
        a2 = 17 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    public SymmetricMatrix(double[][] data) {
        this(new LowerTriangularMatrix(data));
    }

    @Override
    public DenseMatrix toDense() {
        int a2;
        DenseMatrix a3 = this.E.toDense();
        int n = a2 = 1;
        while (n <= this.dim) {
            int n2 = a2 + 1;
            while (n2 <= this.dim) {
                int a4;
                a3.set(a2, a4, this.E.get(a4, a2));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public DenseVector getColumn(int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.getRow(col);
    }

    @Override
    public DenseVector getRow(int row) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, row);
        double[] a3 = ((DenseVector)this.E.getRow(row)).toArray();
        double[] a4 = ((DenseVector)this.E.getColumn(row)).toArray();
        double[] a5 = new double[this.dim];
        int a6 = 0;
        int n = a2 = 0;
        while (true) {
            if (n >= row - 1) break;
            a5[a6++] = a3[a2];
            n = ++a2;
        }
        int n2 = a2 = row - 1;
        while (n2 < this.dim) {
            a5[a6++] = a4[a2];
            n2 = ++a2;
        }
        return new DenseVector(a5);
    }

    @Override
    public SymmetricMatrix scaled(double scalar) {
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).E = this.E.scaled(scalar);
        return a2;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SymmetricMatrix) && obj instanceof MatrixAccessor) {
            return AreMatrices.equal(this, (Matrix)obj, 0.0);
        }
        SymmetricMatrix a2 = (SymmetricMatrix)obj;
        if (this.dim != a2.dim) {
            return false;
        }
        if (!(this.E == a2.E || this.E != null && this.E.equals(a2.E))) {
            return false;
        }
        return true;
    }

    public SymmetricMatrix(int dim) {
        this(new LowerTriangularMatrix(dim));
    }

    @Override
    public String toString() {
        return this.toDense().toString();
    }

    @Override
    public SymmetricMatrix minus(SymmetricMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).E = this.E.minus(that.E);
        return a2;
    }

    public SymmetricMatrix(SymmetricMatrix S) {
        this(S.E);
    }

    @Override
    public SymmetricMatrix deepCopy() {
        return new SymmetricMatrix(this);
    }

    @Override
    public SymmetricMatrix ONE() {
        SymmetricMatrix a2 = new SymmetricMatrix(this.dim);
        new SymmetricMatrix(this.dim).E = this.E.ONE();
        return a2;
    }
}

