/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class DiagonalMatrix
extends DiagonalDataMatrix<DiagonalMatrix> {
    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, v);
        DenseVector a2 = new DenseVector(this.diagonalData.getDiagonal());
        return v.multiply(a2);
    }

    @Override
    public DiagonalMatrix minus(DiagonalMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DiagonalData a2 = this.diagonalData.minus(that.diagonalData);
        return new DiagonalMatrix(a2);
    }

    @Override
    public DiagonalMatrix scaled(double scalar) {
        DiagonalData a2 = this.diagonalData.scaled(scalar);
        return new DiagonalMatrix(a2);
    }

    @Override
    public DiagonalMatrix ZERO() {
        return new DiagonalMatrix(this.diagonalData.dim);
    }

    @Override
    public DiagonalMatrix ONE() {
        double[] a2 = R.rep(1.0, this.diagonalData.dim);
        return new DiagonalMatrix(a2);
    }

    private DiagonalMatrix(DiagonalData a2) {
        super(a2);
        DiagonalMatrix a3;
    }

    public DiagonalMatrix(DiagonalMatrix that) {
        this(that.diagonalData.deepCopy());
    }

    @Override
    public DiagonalMatrix t() {
        return new DiagonalMatrix(this);
    }

    @Override
    public DiagonalMatrix multiply(DiagonalMatrix that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        double[] a3 = this.diagonalData.getDiagonal();
        double[] a4 = that.diagonalData.getDiagonal();
        double[] a5 = new double[this.diagonalData.dim];
        int n = a2 = 0;
        while (n < this.diagonalData.dim) {
            a5[a2] = a3[a2] * a4[a2];
            n = ++a2;
        }
        return new DiagonalMatrix(a5);
    }

    public DiagonalMatrix(double[] data) {
        double[][] dArrayArray = new double[1][];
        dArrayArray[0] = data;
        this(new DiagonalData(dArrayArray));
    }

    @Override
    public DiagonalMatrix add(DiagonalMatrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DiagonalData a2 = this.diagonalData.add(that.diagonalData);
        return new DiagonalMatrix(a2);
    }

    @Override
    public DiagonalMatrix deepCopy() {
        return new DiagonalMatrix(this);
    }

    public DiagonalMatrix(int dim) {
        this(new DiagonalData(DiagonalData.Type.DIAGONAL, dim));
    }
}

