/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;

public class DiagonalData
implements MatrixData,
Densifiable {
    public final Type type;
    private double[][] E;
    public final int dim;

    public DiagonalData(DiagonalData a2) {
        DiagonalData a3;
        a3.E = null;
        a3.dim = a2.dim;
        a3.type = a2.type;
        (a3.E = (double[][])new double[3][])[0] = a2.E[0] != null ? Arrays.copyOf(a2.E[0], a2.E[0].length) : null;
        a3.E[1] = a2.E[1] != null ? Arrays.copyOf(a2.E[1], a2.E[1].length) : null;
        a3.E[2] = a2.E[2] != null ? Arrays.copyOf(a2.E[2], a2.E[2].length) : null;
    }

    public double[] getDiagonal() {
        DiagonalData a2;
        return Arrays.copyOf(a2.E[1], a2.E[1].length);
    }

    @Override
    public DiagonalData deepCopy() {
        return new DiagonalData(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void set(int row, int col, double value) {
        if (row == col - 1) {
            if (this.E[0] != null) {
                this.E[0][row - 1] = value;
                return;
            }
        }
        if (row == col) {
            this.E[1][row - 1] = value;
            return;
        }
        if (row == col + 1) {
            if (this.E[2] != null) {
                this.E[2][row - 2] = value;
                return;
            }
        }
        if (DoubleUtils.compare(0.0, value) == 0) return;
        Object[] objectArray = new Object[2];
        objectArray[0] = row;
        objectArray[1] = col;
        throw new IllegalArgumentException(String.format("U[%d][%d] is always 0", objectArray));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagonalData a2 = (DiagonalData)obj;
        if (this.dim != a2.dim) {
            return false;
        }
        if (this.E != a2.E) {
            int a3;
            int n = a3 = 0;
            while (true) {
                if (n >= 3) break;
                if (this.E[a3] != null && a2.E[a3] != null ? !DoubleUtils.equal(this.E[a3], a2.E[a3], 0.0) : (this.E[a3] == null ? a2.E[a3] != null && !DoubleUtils.isAllZeros(a2.E[a3], 0.0) : a2.E[a3] == null && !DoubleUtils.isAllZeros(this.E[a3], 0.0))) {
                    return false;
                }
                n = ++a3;
            }
        }
        return true;
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.dim, this.dim);
        a2.set(1, 1, this.get(1, 1));
        if (this.dim >= 2) {
            int a3;
            a2.set(1, 2, this.get(1, 2));
            int n = a3 = 2;
            while (n < this.dim) {
                a2.set(a3, a3 - 1, this.get(a3, a3 - 1));
                a2.set(a3, a3, this.get(a3, a3));
                a2.set(a3, a3 + 1, this.get(a3, a3 + 1));
                n = ++a3;
            }
            a2.set(this.dim, this.dim, this.get(this.dim, this.dim));
            a2.set(this.dim, this.dim - 1, this.get(this.dim, this.dim - 1));
        }
        return a2;
    }

    public String toString() {
        return this.toDense().toString();
    }

    private void k(double[] a2) {
        DiagonalData a3;
        a3.E[0] = new double[a3.dim - 1];
        if (a2 != null) {
            SuanShuUtils.assertArgument(a2.length == a3.dim - 1, "data set is not super-diagonal", new Object[0]);
            System.arraycopy(a2, 0, a3.E[0], 0, a3.dim - 1);
        }
    }

    private void m(double[] a2) {
        DiagonalData a3;
        a3.E[2] = new double[a3.dim - 1];
        if (a2 != null) {
            SuanShuUtils.assertArgument(a2.length == a3.dim - 1, "data set is not sub-diagonal", new Object[0]);
            System.arraycopy(a2, 0, a3.E[2], 0, a3.dim - 1);
        }
    }

    public double[] getSubDiagonal() {
        DiagonalData a2;
        double[] a3 = a2.E[2] != null ? Arrays.copyOf(a2.E[2], a2.E[2].length) : new double[a2.dim - 1];
        return a3;
    }

    public DiagonalData opposite() {
        DiagonalData a2;
        return a2.scaled(-1.0);
    }

    public DiagonalData add(DiagonalData a2) {
        int a3;
        DiagonalData a4;
        a4.b(a4, a2);
        DiagonalData a5 = new DiagonalData(a4.type, a4.dim);
        int n = a3 = 0;
        while (true) {
            if (n > 2) break;
            if (a4.E[a3] != null) {
                int a6;
                int a7 = a4.E[a3].length;
                a5.E[a3] = new double[a7];
                int n2 = a6 = 0;
                while (n2 < a7) {
                    a5.E[a3][a6] = a4.E[a3][a6] + a2.E[a3][a6];
                    n2 = ++a6;
                }
            }
            n = ++a3;
        }
        return a5;
    }

    private boolean b(DiagonalData a2, DiagonalData a3) {
        if (a2.type != a3.type) {
            throw new IllegalArgumentException("the two data set are not the same");
        }
        return true;
    }

    public double[] getSuperDiagonal() {
        DiagonalData a2;
        double[] a3 = a2.E[0] != null ? Arrays.copyOf(a2.E[0], a2.E[0].length) : new double[a2.dim - 1];
        return a3;
    }

    public DiagonalData(double[][] a2) {
        DiagonalData a3;
        a3.E = null;
        a3.E = new double[3][];
        switch (a2.length) {
            case 1: {
                a3.type = Type.DIAGONAL;
                a3.dim = a2[0].length;
                a3.b(a2[0]);
                break;
            }
            case 2: {
                if (a2[0].length > a2[1].length) {
                    a3.type = Type.BI_DIAGONAL_LOWER;
                    a3.dim = a2[0].length;
                    a3.b(a2[0]);
                    a3.m(a2[1]);
                    break;
                }
                a3.type = Type.BI_DIAGONAL_UPPER;
                a3.dim = a2[1].length;
                a3.k(a2[0]);
                a3.b(a2[1]);
                break;
            }
            case 3: {
                do {
                } while (false);
                a3.type = Type.TRI_DIAGONAL;
                a3.dim = a2[1].length;
                a3.k(a2[0]);
                a3.b(a2[1]);
                a3.m(a2[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid data set");
            }
        }
    }

    public DiagonalData(Type a2, int a3) {
        DiagonalData a4;
        a4.E = null;
        a4.dim = a3;
        a4.type = a2;
        a4.E = new double[3][];
        switch (a2) {
            case TRI_DIAGONAL: {
                a4.E[0] = new double[a3 - 1];
                a4.E[1] = new double[a3];
                a4.E[2] = new double[a3 - 1];
                break;
            }
            case BI_DIAGONAL_UPPER: {
                a4.E[0] = new double[a3 - 1];
                a4.E[1] = new double[a3];
                break;
            }
            case BI_DIAGONAL_LOWER: {
                a4.E[1] = new double[a3];
                a4.E[2] = new double[a3 - 1];
                break;
            }
            case DIAGONAL: {
                do {
                } while (false);
                a4.E[1] = new double[a3];
            }
        }
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 47 * a2 + this.dim;
        a2 = 47 * a2 + (this.E != null ? this.E.hashCode() : 0);
        a2 = 47 * a2 + (this.type != null ? this.type.hashCode() : 0);
        return a2;
    }

    public DiagonalData minus(DiagonalData a2) {
        int a3;
        DiagonalData a4;
        a4.b(a4, a2);
        DiagonalData a5 = new DiagonalData(a4.type, a4.dim);
        int n = a3 = 0;
        while (true) {
            if (n > 2) break;
            if (a4.E[a3] != null) {
                int a6;
                int a7 = a4.E[a3].length;
                a5.E[a3] = new double[a7];
                int n2 = a6 = 0;
                while (n2 < a7) {
                    a5.E[a3][a6] = a4.E[a3][a6] - a2.E[a3][a6];
                    n2 = ++a6;
                }
            }
            n = ++a3;
        }
        return a5;
    }

    private void b(double[] a2) {
        DiagonalData a3;
        a3.E[1] = new double[a3.dim];
        if (a2 != null) {
            SuanShuUtils.assertArgument(a2.length == a3.dim, "data set is not diagonal", new Object[0]);
            System.arraycopy(a2, 0, a3.E[1], 0, a3.dim);
        }
    }

    public DiagonalData scaled(double a2) {
        int a3;
        DiagonalData a4;
        DiagonalData a5 = new DiagonalData(a4.type, a4.dim);
        int n = a3 = 0;
        while (true) {
            if (n > 2) break;
            if (a4.E[a3] != null) {
                int a6;
                int a7 = a4.E[a3].length;
                a5.E[a3] = new double[a7];
                int n2 = a6 = 0;
                while (n2 < a7) {
                    a5.E[a3][a6] = a4.E[a3][a6] * a2;
                    n2 = ++a6;
                }
            }
            n = ++a3;
        }
        return a5;
    }

    @Override
    public double get(int row, int col) {
        if (this.E == null) {
            return 0.0;
        }
        double a2 = row == col - 1 ? (this.E[0] != null ? this.E[0][row - 1] : 0.0) : (row == col ? (this.E[1] != null ? this.E[1][row - 1] : 0.0) : (row == col + 1 ? (this.E[2] != null ? this.E[2][row - 2] : 0.0) : 0.0));
        return a2;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BI_DIAGONAL_LOWER;
        public static final /* enum */ Type TRI_DIAGONAL;
        public static final /* enum */ Type BI_DIAGONAL_UPPER;
        public static final /* enum */ Type DIAGONAL;
        private static final /* synthetic */ Type[] E;

        public static Type[] values() {
            return (Type[])E.clone();
        }

        static {
            TRI_DIAGONAL = new Type();
            BI_DIAGONAL_UPPER = new Type();
            BI_DIAGONAL_LOWER = new Type();
            DIAGONAL = new Type();
            Type[] typeArray = new Type[4];
            typeArray[0] = TRI_DIAGONAL;
            typeArray[1] = BI_DIAGONAL_UPPER;
            typeArray[2] = BI_DIAGONAL_LOWER;
            typeArray[3] = DIAGONAL;
            E = typeArray;
        }

        private Type() {
            Type a2;
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }
    }
}

