/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class BidiagonalMatrix
extends DiagonalDataMatrix<BidiagonalMatrix> {
    public boolean isUnreduced(double epsilon) {
        int a2;
        double[] a3 = this.diagonalData.getDiagonal();
        int n = a2 = 0;
        while (n < a3.length) {
            if (DoubleUtils.compare(a3[a2], 0.0, epsilon) == 0) {
                return false;
            }
            n = ++a2;
        }
        a3 = this.getSuperDiagonal().toArray();
        int n2 = a2 = 0;
        while (n2 < a3.length) {
            if (DoubleUtils.compare(a3[a2], 0.0, epsilon) == 0) {
                return false;
            }
            n2 = ++a2;
        }
        return true;
    }

    @Override
    public BidiagonalMatrix deepCopy() {
        return new BidiagonalMatrix(this);
    }

    public BidiagonalMatrixType getType() {
        switch (this.diagonalData.type) {
            case BI_DIAGONAL_UPPER: {
                return BidiagonalMatrixType.UPPER;
            }
            case BI_DIAGONAL_LOWER: {
                do {
                } while (false);
                return BidiagonalMatrixType.LOWER;
            }
        }
        throw new RuntimeException("inconsistent diagonal data");
    }

    private BidiagonalMatrix(DiagonalData a2) {
        super(a2);
        BidiagonalMatrix a3;
    }

    private TridiagonalMatrix b(BidiagonalMatrix a2) {
        int a3;
        BidiagonalMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        int a5 = a4.diagonalData.dim;
        double[] a6 = new double[a5 - 1];
        double[] a7 = new double[a5];
        double[] a8 = new double[a5 - 1];
        DenseVector a9 = a4.getRow(1);
        DenseVector a10 = a2.getColumn(1);
        a7[0] = a9.innerProduct(a10);
        a10 = a2.getColumn(2);
        a6[0] = a9.innerProduct(a10);
        int n = a3 = 2;
        while (n < a5) {
            a9 = a4.getRow(a3);
            a10 = a2.getColumn(a3 - 1);
            a8[a3 - 2] = a9.innerProduct(a10);
            a10 = a2.getColumn(a3);
            a7[a3 - 1] = a9.innerProduct(a10);
            a10 = a2.getColumn(a3 + 1);
            a6[a3 - 1] = a9.innerProduct(a10);
            n = ++a3;
        }
        a9 = a4.getRow(a5);
        a10 = a2.getColumn(a5);
        a7[a5 - 1] = a9.innerProduct(a10);
        a10 = a2.getColumn(a5 - 1);
        a8[a5 - 2] = a9.innerProduct(a10);
        double[][] dArrayArray = new double[3][];
        dArrayArray[0] = a6;
        dArrayArray[1] = a7;
        dArrayArray[2] = a8;
        return new TridiagonalMatrix(dArrayArray);
    }

    private static DiagonalData b(double[][] a2) {
        if (a2[0] != null) {
            if (a2[1] == null) {
            }
        } else {
            double[] a3 = a2[0] == null ? a2[1] : a2[0];
            double[][] dArrayArray = new double[2][];
            dArrayArray[0] = R.rep(0.0, a3.length - 1);
            dArrayArray[1] = a3;
            return new DiagonalData(dArrayArray);
        }
        return new DiagonalData(a2);
    }

    private static DiagonalData b(int a2, BidiagonalMatrixType a3) {
        return new DiagonalData(a3 == BidiagonalMatrixType.UPPER ? DiagonalData.Type.BI_DIAGONAL_UPPER : DiagonalData.Type.BI_DIAGONAL_LOWER, a2);
    }

    @Override
    public BidiagonalMatrix ONE() {
        double[] a2 = R.rep(1.0, this.diagonalData.dim);
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = null;
        dArrayArray[1] = a2;
        return new BidiagonalMatrix(dArrayArray);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof BidiagonalMatrix && this.getType() != ((BidiagonalMatrix)that).getType()) {
            return this.b((BidiagonalMatrix)that);
        }
        return super.multiply(that);
    }

    public BidiagonalMatrix(int dim, BidiagonalMatrixType type) {
        this(BidiagonalMatrix.b(dim, type));
    }

    @Override
    public BidiagonalMatrix scaled(double scalar) {
        return new BidiagonalMatrix(this.diagonalData.scaled(scalar));
    }

    public BidiagonalMatrix(BidiagonalMatrix that) {
        this(that.diagonalData.deepCopy());
    }

    public BidiagonalMatrix(double[][] data) {
        this(BidiagonalMatrix.b(data));
    }

    @Override
    public BidiagonalMatrix t() {
        double[][] a2 = new double[2][];
        if (this.getType() == BidiagonalMatrixType.UPPER) {
            a2[0] = this.diagonalData.getDiagonal();
            a2[1] = this.diagonalData.getSuperDiagonal();
        } else {
            a2[0] = this.diagonalData.getSubDiagonal();
            a2[1] = this.diagonalData.getDiagonal();
        }
        return new BidiagonalMatrix(a2);
    }

    @Override
    public BidiagonalMatrix ZERO() {
        return new BidiagonalMatrix(this.diagonalData.dim, BidiagonalMatrixType.UPPER);
    }

    public static final class BidiagonalMatrixType
    extends Enum<BidiagonalMatrixType> {
        public static final /* enum */ BidiagonalMatrixType LOWER;
        public static final /* enum */ BidiagonalMatrixType UPPER;
        private static final /* synthetic */ BidiagonalMatrixType[] E;

        public static BidiagonalMatrixType valueOf(String name) {
            return Enum.valueOf(BidiagonalMatrixType.class, name);
        }

        static {
            UPPER = new BidiagonalMatrixType();
            LOWER = new BidiagonalMatrixType();
            BidiagonalMatrixType[] bidiagonalMatrixTypeArray = new BidiagonalMatrixType[2];
            bidiagonalMatrixTypeArray[0] = UPPER;
            bidiagonalMatrixTypeArray[1] = LOWER;
            E = bidiagonalMatrixTypeArray;
        }

        public static BidiagonalMatrixType[] values() {
            return (BidiagonalMatrixType[])E.clone();
        }

        private BidiagonalMatrixType() {
            BidiagonalMatrixType a2;
        }
    }
}

