/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.number.ScientificNotation;
import com.numericalmethod.suanshu.number.big.BigIntegerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class HilbertMatrix
extends SymmetricMatrix {
    public HilbertMatrix(int dim) {
        super(dim);
        int a2;
        int n = a2 = 1;
        while (n <= dim) {
            int n2 = a2;
            while (n2 <= dim) {
                int a3;
                this.set(a2, a3, 1.0 / (double)(a2 + a3 - 1));
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public double det() {
        ScientificNotation a2 = new ScientificNotation(this.invdet());
        return BigDecimal.ONE.divide(a2.value(), Math.abs(a2.exponent) + Constant.MACH_SCALE, RoundingMode.HALF_EVEN).doubleValue();
    }

    public BigInteger invdet() {
        int a2;
        BigInteger a3 = BigIntegerUtils.factorial(this.dim);
        int n = a2 = 1;
        while (true) {
            if (n > 2 * this.dim - 1) break;
            BigInteger a4 = BigIntegerUtils.combination(a2, a2 / 2);
            a3 = a3.multiply(a4);
            n = ++a2;
        }
        return a3;
    }
}

