/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.HouseholderReflection;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class OLSSolverByQR {
    private final int k;
    private final UpperTriangularMatrix L;
    private final Matrix E;

    public OLSSolverByQR(Matrix A, double epsilon) {
        this.k = A.nRows();
        HouseholderReflection a2 = new HouseholderReflection(A, epsilon);
        this.E = a2.squareQ().t();
        this.L = a2.R();
    }

    public Vector solve(Vector y) {
        SuanShuUtils.assertArgument(y.size() == this.k, "y does not have the correct length", new Object[0]);
        Vector a2 = CreateVector.subVector(this.E.multiply(y), 1, this.L.dim());
        Vector a3 = new BackwardSubstitution(this.L).solve(a2);
        return a3;
    }
}

