/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LinearSystemSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class ForwardSubstitution {
    public final LowerTriangularMatrix L;

    public ForwardSubstitution(LowerTriangularMatrix L) {
        this.L = L;
    }

    public Vector solve(Vector b2) {
        int a2;
        SuanShuUtils.assertArgument(this.L.dim() == b2.size(), "b must have the same length as L's dimension", new Object[0]);
        int a3 = b2.size();
        DenseVector a4 = new DenseVector(a3);
        int n = a2 = 1;
        while (n <= a3) {
            int a5;
            a4.set(a2, b2.get(a2));
            int n2 = a5 = 1;
            while (n2 < a2) {
                a4.set(a2, a4.get(a2) - this.L.get(a2, a5) * a4.get(a5));
                n2 = ++a5;
            }
            if (DoubleUtils.compare(this.L.get(a2, a2), 0.0) != 0) {
                a4.set(a2, a4.get(a2) / this.L.get(a2, a2));
            } else if (DoubleUtils.compare(a4.get(a2), 0.0) != 0) {
                throw new LinearSystemSolver.NoSolution("no solution to this system of linear equations");
            }
            n = ++a2;
        }
        return a4;
    }
}

