/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class LDL {
    private final int F;
    private DiagonalMatrix k;
    private LowerTriangularMatrix L;
    private final Matrix E;

    public UpperTriangularMatrix Lt() {
        return this.L.t();
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.L);
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.k);
    }

    public LDL(Matrix A) {
        if (!IsMatrix.symmetric(A)) {
            throw new IllegalArgumentException("LDL decomposition applies to only symmetric matrix");
        }
        this.F = A.nRows();
        this.E = A;
        this.b();
    }

    private void b() {
        int a2;
        LDL a3;
        a3.L = new LowerTriangularMatrix(a3.F);
        a3.k = new DiagonalMatrix(a3.F);
        int n = a2 = 1;
        while (n <= a3.F) {
            int a4;
            int a5;
            int n2 = a5 = 1;
            while (n2 < a2) {
                if (DoubleUtils.compare(a3.k.get(a5, a5), 0.0) == 0) {
                    a3.L.set(a2, a5, 0.0);
                } else {
                    int a6;
                    double a7 = a3.E.get(a2, a5);
                    int n3 = a6 = 1;
                    while (true) {
                        if (n3 > a5 - 1) break;
                        a7 -= a3.L.get(a2, a6) * a3.L.get(a5, a6) * a3.k.get(a6, a6);
                        n3 = ++a6;
                    }
                    a3.L.set(a2, a5, a7 /= a3.k.get(a5, a5));
                }
                n2 = ++a5;
            }
            a3.L.set(a2, a2, 1.0);
            double a22 = a3.E.get(a2, a2);
            int n4 = a4 = 1;
            while (true) {
                if (n4 > a2 - 1) break;
                a22 -= a3.L.get(a2, a4) * a3.L.get(a2, a4) * a3.k.get(a4, a4);
                n4 = ++a4;
            }
            a3.k.set(a2, a2, a22);
            n = ++a2;
        }
    }
}

