/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Cholesky {
    private LowerTriangularMatrix E;

    public Cholesky(Matrix A) {
        if (!IsMatrix.symmetric(A)) {
            throw new IllegalArgumentException("Cholesky decomposition applies to only symmetric matrix");
        }
        this.b(A);
    }

    private void b(Matrix a2) {
        int a3;
        int a4 = a2.nRows();
        a6.E = new LowerTriangularMatrix(a4);
        int n = a3 = 1;
        while (n <= a4) {
            int a5;
            Cholesky a6;
            int a7;
            int n2 = a7 = 1;
            while (n2 < a3) {
                int a8;
                double a9 = a2.get(a3, a7);
                int n3 = a8 = 1;
                while (true) {
                    if (n3 > a7 - 1) break;
                    a9 -= a6.E.get(a3, a8) * a6.E.get(a7, a8);
                    n3 = ++a8;
                }
                a6.E.set(a3, a7, a9 /= a6.E.get(a7, a7));
                n2 = ++a7;
            }
            double a22 = a2.get(a3, a3);
            int n4 = a5 = 1;
            while (true) {
                if (n4 > a3 - 1) break;
                a22 -= a6.E.get(a3, a5) * a6.E.get(a3, a5);
                n4 = ++a5;
            }
            if (DoubleUtils.compare(a22, 0.0) <= 0) {
                throw new RuntimeException("A is not positive definite");
            }
            a22 = Math.sqrt(a22);
            a6.E.set(a3, a3, a22);
            n = ++a3;
        }
    }

    public UpperTriangularMatrix Lt() {
        return this.E.t();
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.E);
    }
}

