/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.svd;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class GloubKahanSVDStep {
    private final int G;
    private final BidiagonalMatrix F;
    private final GivensMatrix[] k;
    private final GivensMatrix[] L;
    private final BidiagonalMatrix E;

    public BidiagonalMatrix UtBV() {
        GloubKahanSVDStep a2;
        return new BidiagonalMatrix(a2.E);
    }

    private BidiagonalMatrix b() {
        int a2;
        GloubKahanSVDStep a3;
        Matrix a4 = ((BidiagonalMatrix)a3.F.t()).multiply(a3.F);
        double a5 = a4.get(a3.G, a3.G);
        CharacteristicPolynomial a6 = new CharacteristicPolynomial(CreateMatrix.subMatrix(a4, a3.G - 1, a3.G, a3.G - 1, a3.G));
        double a7 = ((Number)a6.getEigenvalues().get(0)).doubleValue();
        double a8 = ((Number)a6.getEigenvalues().get(1)).doubleValue();
        double a9 = Math.abs(a7 - a5) < Math.abs(a8 - a5) ? a7 : a8;
        Matrix a10 = a3.F.deepCopy();
        double a11 = a4.get(1, 1) - a9;
        double a12 = a4.get(1, 2);
        int n = a2 = 1;
        while (true) {
            if (n > a3.G - 1) break;
            a3.L[a2 - 1] = GivensMatrix.CtorToRotateColumns(a3.G, a2, a2 + 1, a11, a12);
            a10 = a3.L[a2 - 1].rightMultiply(a10);
            a11 = a10.get(a2, a2);
            a12 = a10.get(a2 + 1, a2);
            a3.k[a2 - 1] = GivensMatrix.CtorToRotateColumns(a3.G, a2, a2 + 1, a11, a12);
            a10 = a3.k[a2 - 1].t().multiply(a10);
            if (a2 < a3.G - 1) {
                a11 = a10.get(a2, a2 + 1);
                a12 = a10.get(a2, a2 + 2);
            }
            n = ++a2;
        }
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = CreateVector.superDiagonal(a10).toArray();
        dArrayArray[1] = CreateVector.diagonal(a10).toArray();
        return new BidiagonalMatrix(dArrayArray);
    }

    public Matrix U() {
        GloubKahanSVDStep a2;
        return GivensMatrix.product(a2.k);
    }

    public GloubKahanSVDStep(BidiagonalMatrix a2) {
        GloubKahanSVDStep a3;
        a3.F = a2;
        a3.G = a2.nRows();
        a3.k = new GivensMatrix[a3.G - 1];
        a3.L = new GivensMatrix[a3.G - 1];
        a3.E = a3.b();
    }

    public Matrix V() {
        GloubKahanSVDStep a2;
        return GivensMatrix.product(a2.L);
    }
}

