/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.GramSchmidt;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.HouseholderReflection;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class QR
implements QRDecomposition {
    public final double epsilon;
    private final QRDecomposition E;

    @Override
    public int rank() {
        return this.E.rank();
    }

    public QR(Matrix A) {
        this(A, Method.HOUSEHOLDER_REFLECTION, SuanShuUtils.autoEpsilon(A));
    }

    @Override
    public UpperTriangularMatrix R() {
        return this.E.R();
    }

    @Override
    public Matrix squareQ() {
        return this.E.squareQ();
    }

    @Override
    public Matrix Q() {
        return this.E.Q();
    }

    @Override
    public PermutationMatrix P() {
        return this.E.P();
    }

    public QR(Matrix A, Method method, double epsilon) {
        SuanShuUtils.assertArgument(A.nRows() >= A.nCols(), "the QR decomposition applies to matrix where number of rows > number of columns", new Object[0]);
        this.epsilon = epsilon;
        switch (method) {
            case GRAM_SCHMIDT: {
                do {
                } while (false);
                this.E = new GramSchmidt(A, true, epsilon);
                break;
            }
            default: {
                this.E = new HouseholderReflection(A, epsilon);
            }
        }
    }

    @Override
    public Matrix tallR() {
        return this.E.tallR();
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method HOUSEHOLDER_REFLECTION;
        public static final /* enum */ Method GRAM_SCHMIDT;
        private static final /* synthetic */ Method[] E;

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            GRAM_SCHMIDT = new Method();
            HOUSEHOLDER_REFLECTION = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = GRAM_SCHMIDT;
            methodArray[1] = HOUSEHOLDER_REFLECTION;
            E = methodArray;
        }

        public static Method[] values() {
            return (Method[])E.clone();
        }

        private Method() {
            Method a2;
        }
    }
}

