/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class HouseholderReflection
implements QRDecomposition {
    public final int ncols;
    private Householder[] k;
    public final int nrows;
    private Vector[] L;
    private UpperTriangularMatrix E;
    public final double epsilon;

    @Override
    public Matrix squareQ() {
        return Householder.product(this.k, 1, this.ncols, this.nrows, this.nrows);
    }

    public HouseholderReflection(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(A));
    }

    @Override
    public UpperTriangularMatrix R() {
        return new UpperTriangularMatrix(this.E);
    }

    @Override
    public Matrix tallR() {
        DenseMatrix a2 = new DenseMatrix(this.nrows, this.ncols).ZERO();
        CreateMatrix.replace(a2, 1, this.ncols, 1, this.ncols, this.E);
        return a2;
    }

    public HouseholderReflection(Matrix A, double epsilon) {
        int a2;
        SuanShuUtils.assertArgument(A.nRows() >= A.nCols(), "QR decomposition by Householder Reflection applies to matrix where number of rows > number of columns", new Object[0]);
        this.nrows = A.nRows();
        this.ncols = A.nCols();
        this.epsilon = epsilon;
        this.E = new UpperTriangularMatrix(this.ncols);
        this.E.set(1, 1, 0.0);
        this.L = new Vector[this.ncols + 1];
        this.k = new Householder[this.ncols + 1];
        int n = a2 = 1;
        while (n <= this.ncols) {
            this.L[a2] = A.getColumn(a2);
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (true) {
            if (n2 > Math.min(this.ncols, this.nrows - 1)) break;
            Householder.Context a3 = Householder.getContext(CreateVector.subVector(this.L[a2], a2, this.nrows));
            Vector a4 = a3.generator;
            if (DoubleUtils.compare(Math.abs(a3.lambda), epsilon) <= 0) {
                a4 = new DenseVector(this.nrows);
                this.k[a2] = new Householder(a4);
                this.E.set(a2, a2, 0.0);
            } else {
                Vector[] vectorArray = new Vector[2];
                vectorArray[0] = new DenseVector(a2 - 1);
                vectorArray[1] = a4;
                a4 = CreateVector.concat(vectorArray);
                this.k[a2] = new Householder(a4);
                int n3 = a2 + 1;
                while (n3 <= this.ncols) {
                    int a5;
                    this.L[a5] = this.k[a2].reflect(this.L[a5]);
                    n3 = ++a5;
                }
                this.E.set(a2, a2, a3.lambda);
            }
            n2 = ++a2;
        }
        this.b();
    }

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.ncols);
    }

    @Override
    public int rank() {
        int a2;
        int a3 = 0;
        int n = a2 = 1;
        while (n <= this.E.nCols()) {
            if (DoubleUtils.compare(this.E.get(a2, a2), 0.0, this.epsilon) != 0) {
                ++a3;
            }
            n = ++a2;
        }
        return a3;
    }

    private void b() {
        HouseholderReflection a2;
        int a3;
        int n = a3 = 2;
        while (n <= a2.ncols) {
            int a4;
            int n2 = a4 = 1;
            while (n2 < a3) {
                a2.E.set(a4, a3, a2.L[a3].get(a4));
                n2 = ++a4;
            }
            n = ++a3;
        }
        if (a2.nrows == a2.ncols) {
            a2.E.set(a2.ncols, a2.ncols, a2.L[a2.ncols].get(a2.ncols));
        }
    }

    @Override
    public Matrix Q() {
        return Householder.product(this.k, 1, this.ncols, this.nrows, this.ncols);
    }
}

