/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.datastructure.list.MatrixList;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr.FrancisQRStep;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr.Hessenberg;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr.HessenbergDecomposition;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.util.Iterator;

public class QRAlgorithm
implements Spectrum {
    private final int G;
    private final Matrix F;
    private MatrixList k = new MatrixList();
    private final Matrix L;
    public final double epsilon;
    private final int E;

    public QRAlgorithm(Matrix A) {
        this(A, Integer.MAX_VALUE, SuanShuUtils.autoEpsilon(A));
    }

    public QRAlgorithm(Matrix A, int maxIterations, double epsilon) {
        if (!DimensionCheck.isSquare(A)) {
            throw new IllegalArgumentException("Eigenvalue decomposition applies only to square matrix");
        }
        this.E = A.nRows();
        this.L = A;
        this.G = maxIterations;
        this.epsilon = epsilon;
        HessenbergDecomposition a2 = new HessenbergDecomposition(A);
        this.F = a2.H();
        this.k.add(a2.Q());
    }

    public Matrix T() {
        Matrix a2 = this.Q();
        return a2.t().multiply(this.L).multiply(a2);
    }

    public Matrix Q() {
        Iterator a2;
        Matrix a3 = this.F.ONE();
        Iterator iterator = a2 = this.k.iterator();
        while (iterator.hasNext()) {
            Matrix a4 = (Matrix)a2.next();
            a3 = a3.multiply(a4);
            iterator = a2;
        }
        return a3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public NumberList getEigenvalues() {
        a = new Hessenberg();
        a = a.backSearch(this.F, this.E, this.epsilon);
        v0 = a = 0;
        v1 = this;
        while (v0 < v1.G && !a.isQuasiTriangular) {
            a = CreateMatrix.subMatrix(this.F, a.ul, a.lr, a.ul, a.lr);
            a = new FrancisQRStep(a);
            a = a.ZtHZ();
            CreateMatrix.replace(this.F, a.ul, a.lr, a.ul, a.lr, (Matrix)a);
            a = this.F.ONE();
            CreateMatrix.replace((Matrix)a, a.ul, a.lr, a.ul, a.lr, a.Z());
            this.k.add(a);
            a = a.backSearch(this.F, this.E, this.epsilon);
            v0 = ++a;
            v1 = this;
        }
        a = new NumberList();
        v2 = a = 1;
        while (v2 <= this.E) {
            if (a == this.E) ** GOTO lbl-1000
            if (a.deflationCriterion.isNegligible(this.F, a + 1, a, this.epsilon)) lbl-1000:
            // 2 sources

            {
                a = CreateMatrix.subMatrix(this.F, a, a, a, a);
            } else {
                a = CreateMatrix.subMatrix(this.F, a, a + 1, a, a + 1);
                a += 2;
            }
            a = new CharacteristicPolynomial((Matrix)a);
            a = a.getEigenvalues();
            a.addAll(a);
            v2 = ++a;
        }
        return a;
    }
}

