/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.qr.QRAlgorithm;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LinearSystemSolver;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.NumberUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Eigen
implements Spectrum {
    private final TreeMap<Number, Property> k;
    public final double epsilon;
    private volatile boolean L = false;
    private final Matrix E;

    public int size() {
        return this.k.keySet().size();
    }

    public Eigen(Matrix A, Method method, final double epsilon) {
        Spectrum a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), "Eigenvalue decomposition applies only to square matrix", new Object[0]);
        this.epsilon = epsilon;
        this.E = A;
        this.k = new TreeMap(new Comparator<Number>(){
            {
                1 a2;
            }

            @Override
            public int compare(Number o1, Number o2) {
                return -NumberUtils.compare(o1, o2, epsilon);
            }
        });
        switch (method) {
            case CHARACTERISTIC_POLYNOMIAL: {
                a2 = new CharacteristicPolynomial(this.E);
                break;
            }
            case SYMMETRY: {
                do {
                } while (false);
                throw new UnsupportedOperationException("Not supported yet.");
            }
            default: {
                a2 = new QRAlgorithm(this.E, Integer.MAX_VALUE, epsilon);
            }
        }
        for (Number a3 : a2.getEigenvalues()) {
            Property a4;
            if (this.k.containsKey(a3)) {
                a4 = this.k.get(a3);
                ++a4.E;
                continue;
            }
            a4 = new Property(a3, null);
            this.k.put(a3, a4);
        }
    }

    private void b() {
        Eigen a2;
        Iterator<Map.Entry<Number, Property>> a3 = a2.k.entrySet().iterator();
        while (a3.hasNext()) {
            Property a4 = a3.next().getValue();
            Number a5 = a4.k;
            if (!NumberUtils.isReal(a5)) continue;
            Matrix a6 = a2.E.minus(a2.E.ONE().scaled(a5.doubleValue()));
            LinearSystemSolver a7 = new LinearSystemSolver(a6, a2.epsilon);
            VectorList a8 = new VectorList();
            int a9 = 1;
            VectorList vectorList = a8;
            while (vectorList.size() == 0) {
                a7 = new LinearSystemSolver(a6, a2.epsilon * (double)a9);
                a8 = a7.getHomogeneousSoln();
                a9 *= 10;
                vectorList = a8;
            }
            a4.L.addAll(a8);
            if (a4.E <= 1) continue;
            Vector a22 = (Vector)a4.L.get(0);
            Property property = a4;
            while (property.L.size() < a4.E) {
                Vector a10 = a7.solve(a22);
                a4.L.add(a10);
                a22 = a10;
                property = a4;
            }
        }
        a2.L = true;
    }

    public Property getProperty(Number eigenvalue) {
        if (!this.L) {
            this.b();
        }
        return new Property(this.k.get(eigenvalue), null);
    }

    public double[] getRealEigenvalues() {
        NumberList a2 = new NumberList();
        for (Number a3 : this.k.keySet()) {
            if (!NumberUtils.isReal(a3)) continue;
            a2.add(a3);
        }
        return a2.toDoubleArray();
    }

    public Eigen(Matrix A) {
        this(A, Method.QR, SuanShuUtils.autoEpsilon(A));
    }

    public Property getProperty(int i2) {
        return this.getProperty(this.getEigenvalue(i2));
    }

    @Override
    public NumberList getEigenvalues() {
        NumberList a2 = new NumberList();
        a2.addAll(this.k.keySet());
        return a2;
    }

    public Number getEigenvalue(int i2) {
        int a2;
        Iterator<Number> a3 = this.k.keySet().iterator();
        int n = a2 = 0;
        while (n < i2) {
            a3.next();
            n = ++a2;
        }
        return a3.next();
    }

    public static class Property {
        private Number k;
        private VectorList L;
        private int E;

        public Number eigenvalue() {
            return this.k;
        }

        public Vector eigenVector() {
            return (Vector)this.L.get(0);
        }

        public /* synthetic */ Property(Property a2, 1 a3) {
            a4(a2);
            Property a4;
        }

        public VectorList eigenbasis() {
            return this.L.deepCopy();
        }

        public int algebraicMultiplicity() {
            return this.E;
        }

        private Property(Property a2) {
            Property a3;
            a3.k = a2.k;
            a3.E = a2.E;
            a3.L = new VectorList(a2.L);
        }

        private Property(Number a2) {
            Property a3;
            a3.k = a2;
            a3.E = 1;
            a3.L = new VectorList();
        }

        public /* synthetic */ Property(Number a2, 1 a3) {
            a4(a2);
            Property a4;
        }

        public int geometricMultiplicity() {
            return this.L.size();
        }
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method QR;
        public static final /* enum */ Method CHARACTERISTIC_POLYNOMIAL;
        private static final /* synthetic */ Method[] E;
        public static final /* enum */ Method SYMMETRY;

        public static Method[] values() {
            return (Method[])E.clone();
        }

        static {
            CHARACTERISTIC_POLYNOMIAL = new Method();
            SYMMETRY = new Method();
            QR = new Method();
            Method[] methodArray = new Method[3];
            methodArray[0] = CHARACTERISTIC_POLYNOMIAL;
            methodArray[1] = SYMMETRY;
            methodArray[2] = QR;
            E = methodArray;
        }

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }
    }
}

