/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolynomialSolver;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.Polyroot;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixMeasure;

public class CharacteristicPolynomial
implements Spectrum {
    private final Matrix L;
    private final Polynomial E;

    public CharacteristicPolynomial(Matrix A) {
        if (!DimensionCheck.isSquare(A)) {
            throw new IllegalArgumentException("Eigenvalue decomposition applies only to square matrix");
        }
        this.L = A;
        this.E = this.getCharacteristicPolynomial();
    }

    public String toString() {
        return this.E.toString();
    }

    @Override
    public NumberList getEigenvalues() {
        NumberList a2 = new NumberList();
        switch (this.L.nRows()) {
            case 1: {
                a2.add(new Double(this.L.get(1, 1)));
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                do {
                } while (false);
                a2 = new Polyroot(new PolynomialSolver[0]).solve(this.E);
                break;
            }
            default: {
                throw new IllegalArgumentException("by Abel-Ruffini theorem, a general polynomial of order n\u2008>\u20084 cannot be solved by a finite sequence of arithmetic operations and radicals");
            }
        }
        return a2;
    }

    public Polynomial getCharacteristicPolynomial() {
        Polynomial a2;
        switch (this.L.nRows()) {
            case 1: {
                double[] dArray = new double[2];
                dArray[0] = 1.0;
                dArray[1] = -this.L.get(1, 1);
                a2 = new Polynomial(dArray);
                break;
            }
            case 2: {
                double[] dArray = new double[3];
                dArray[0] = 1.0;
                dArray[1] = -MatrixMeasure.tr(this.L);
                dArray[2] = MatrixMeasure.det(this.L);
                a2 = new Polynomial(dArray);
                break;
            }
            case 3: {
                a2 = null;
                break;
            }
            case 4: {
                do {
                } while (false);
                a2 = null;
                break;
            }
            default: {
                a2 = null;
            }
        }
        return a2;
    }
}

