/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.factorization.diagonalization;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Householder;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class Bidiagonalization {
    private Householder[] G;
    private BidiagonalMatrix F;
    private final int k;
    private Householder[] L;
    private final int E;

    public Matrix V() {
        int a2;
        int n = a2 = 1;
        while (n < this.L.length) {
            Vector a3 = this.L[a2].generator();
            Vector[] vectorArray = new Vector[2];
            vectorArray[0] = new DenseVector(a2);
            vectorArray[1] = a3;
            a3 = CreateVector.concat(vectorArray);
            this.L[a2] = new Householder(a3);
            n = ++a2;
        }
        Matrix a22 = null;
        a22 = this.L.length > 1 ? Householder.product(this.L, this.L.length - 1, 1) : new DenseMatrix(this.E, this.E).ONE();
        return a22.t();
    }

    public Bidiagonalization(Matrix A) {
        Object a2;
        int a3;
        SuanShuUtils.assertArgument(DimensionCheck.isTall(A), "Bidiagonalization applies only to tall matrices", new Object[0]);
        this.k = A.nRows();
        this.E = A.nCols();
        Matrix a4 = A.deepCopy();
        this.G = new Householder[this.E + 1];
        this.L = new Householder[this.E - 1];
        int n = a3 = 1;
        while (n <= this.E) {
            a2 = Householder.getContext(CreateVector.subVector(a4.getColumn(a3), a3, this.k));
            this.G[a3] = new Householder(((Householder.Context)a2).generator);
            DenseMatrix a5 = CreateMatrix.subMatrix(a4, a3, this.k, a3, this.E);
            Matrix a6 = this.G[a3].reflect(a5);
            CreateMatrix.replace(a4, a3, this.k, a3, this.E, a6);
            if (a3 <= this.E - 2) {
                a2 = Householder.getContext(CreateVector.subVector(a4.getRow(a3), a3 + 1, this.E));
                this.L[a3] = new Householder(((Householder.Context)a2).generator);
                DenseMatrix a7 = CreateMatrix.subMatrix(a4, a3, this.k, a3 + 1, this.E);
                Matrix a8 = this.L[a3].reflectRows(a7);
                CreateMatrix.replace(a4, a3, this.k, a3 + 1, this.E, a8);
            }
            n = ++a3;
        }
        double[] a22 = a4.nCols() > 1 ? CreateVector.superDiagonal(a4).toArray() : null;
        a2 = CreateVector.diagonal(a4).toArray();
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = a22;
        dArrayArray[1] = (double[])a2;
        this.F = new BidiagonalMatrix(dArrayArray);
    }

    public BidiagonalMatrix B() {
        return new BidiagonalMatrix(this.F);
    }

    public Matrix U() {
        int a2;
        int n = a2 = 1;
        while (n < this.G.length) {
            Vector a3 = this.G[a2].generator();
            Vector[] vectorArray = new Vector[2];
            vectorArray[0] = new DenseVector(a2 - 1);
            vectorArray[1] = a3;
            a3 = CreateVector.concat(vectorArray);
            this.G[a2] = new Householder(a3);
            n = ++a2;
        }
        Matrix a22 = Householder.product(this.G, this.G.length - 1, 1);
        return a22.t();
    }
}

