/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix;

import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.MatrixMismatchException;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class DimensionCheck {
    public static boolean isColumnVector(MatrixDimension A) {
        return A.nCols() == 1;
    }

    public static void throwIfDifferentDimension(MatrixDimension A1, MatrixDimension A2) {
        if (!DimensionCheck.isSameDimension(A1, A2)) {
            throw new MatrixMismatchException("matrices do not have the same dimension");
        }
    }

    public static boolean isSameDimension(MatrixDimension A1, MatrixDimension A2) {
        return A1.nRows() == A2.nRows() && A1.nCols() == A2.nCols();
    }

    private DimensionCheck() {
        DimensionCheck a2;
    }

    public static void throwIfIncompatible4Multiplication(MatrixDimension A, Vector v) {
        if (A.nCols() != v.size()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = A.nCols();
            objectArray[1] = v.size();
            throw new MatrixMismatchException(String.format("matrix with %d columns and vector with %d elements cannot multiply for mis-matched dimension", objectArray));
        }
    }

    public static boolean isRowVector(MatrixDimension A) {
        return A.nRows() == 1;
    }

    public static boolean isTall(MatrixDimension A) {
        return A.nRows() >= A.nCols();
    }

    public static void throwIfInvalidRow(MatrixDimension A, int row) {
        if (row < 1 || row > A.nRows()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = A.nRows();
            objectArray[1] = row;
            throw new MatrixAccessException(String.format("out of range [1:%d] row index: %d", objectArray));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVector(MatrixDimension A) {
        if (A.nCols() == 1) return true;
        if (A.nRows() != 1) return false;
        return true;
    }

    public static boolean isFat(MatrixDimension A) {
        return A.nCols() >= A.nRows();
    }

    public static void throwIfInvalidColumn(MatrixDimension A, int col) {
        if (col < 1 || col > A.nCols()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = A.nCols();
            objectArray[1] = col;
            throw new MatrixAccessException(String.format("out of range [1:%d] column index: %d", objectArray));
        }
    }

    public static void throwIfIncompatible4Multiplication(MatrixDimension A1, MatrixDimension A2) {
        if (A1.nCols() != A2.nRows()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = A1.nCols();
            objectArray[1] = A2.nRows();
            throw new MatrixMismatchException(String.format("matrix with %d columns and matrix with %d rows cannot multiply for mis-matched dimension", objectArray));
        }
    }

    public static boolean isSquare(MatrixDimension A) {
        return A.nRows() == A.nCols();
    }
}

