/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.uniroot;

import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.uniroot.Uniroot;

public class Newton
extends Uniroot {
    public final UnivariateRealFunction df;

    public double solve(int maxIterations, double guess) {
        double[] dArray = new double[1];
        dArray[0] = guess;
        return this.solve(maxIterations, Double.MIN_VALUE, Double.MAX_VALUE, dArray);
    }

    public Newton(UnivariateRealFunction f2, UnivariateRealFunction df, double tol) {
        super(f2, tol);
        this.df = df;
    }

    @Override
    public double solve(int maxIterations, double lower, double upper, double ... guess) {
        int a2;
        double a3;
        double a4 = a3 = guess[0];
        double a5 = this.f.evaluate(a4);
        int n = a2 = 0;
        int n2 = maxIterations;
        while (n < n2 && Math.abs(a5) > this.tol) {
            a4 = a3 - this.f.evaluate(a3) / this.df.evaluate(a3);
            a5 = this.f.evaluate(a4);
            a3 = a4;
            n = ++a2;
            n2 = maxIterations;
        }
        return a4;
    }

    public Newton(UnivariateRealFunction f2, double tol) {
        super(f2, tol);
        this.df = new FiniteDifference(f2, 1, FiniteDifference.FiniteDifferenceType.CENTRAL);
    }
}

