/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.uniroot;

import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.uniroot.Uniroot;

public class Halley
extends Uniroot {
    public final UnivariateRealFunction df;
    public final UnivariateRealFunction d2f;

    public Halley(UnivariateRealFunction f2, double tol) {
        super(f2, tol);
        this.df = new FiniteDifference(f2, 1, FiniteDifference.FiniteDifferenceType.CENTRAL);
        this.d2f = new FiniteDifference(f2, 2, FiniteDifference.FiniteDifferenceType.CENTRAL);
    }

    public Halley(UnivariateRealFunction f2, UnivariateRealFunction df, UnivariateRealFunction d2f, double tol) {
        super(f2, tol);
        this.df = df;
        this.d2f = d2f;
    }

    public double solve(int maxIterations, double guess) {
        double[] dArray = new double[1];
        dArray[0] = guess;
        return this.solve(maxIterations, Double.MIN_VALUE, Double.MAX_VALUE, dArray);
    }

    @Override
    public double solve(int iterations, double lower, double upper, double ... guess) {
        int a2;
        double a3;
        double a4 = a3 = guess[0];
        double a5 = this.f.evaluate(a4);
        int n = a2 = 0;
        int n2 = iterations;
        while (n < n2 && Math.abs(a5) > this.tol) {
            double a6 = this.df.evaluate(a3);
            a4 = 2.0 * a5 * a6;
            a4 /= 2.0 * a6 * a6 - a5 * this.d2f.evaluate(a3);
            a4 = a3 - a4;
            a5 = this.f.evaluate(a4);
            a3 = a4;
            n = ++a2;
            n2 = iterations;
        }
        return a4;
    }
}

