/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.sequence;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class Summation {
    public final Term term;
    public final double threshold;

    public double sum(double[] indices) {
        int a2;
        double a3 = 0.0;
        double[] a4 = indices;
        int a5 = indices.length;
        int n = a2 = 0;
        while (n < a5) {
            double a6 = a4[a2];
            double a7 = this.term.evaluate(a6);
            a3 += a7;
            n = ++a2;
        }
        return a3;
    }

    public double sum(double from, double to, double inc) {
        double[] a2 = R.seq(from, to, inc);
        return this.sum(a2);
    }

    public double sumToInfinity(int from) {
        return this.sumToInfinity(from, 1.0);
    }

    public double sum(int from, int to, int inc) {
        return this.sum((double)from, (double)to, (double)inc);
    }

    public double sum(int from, int to) {
        return this.sum(from, to, 1);
    }

    public Summation(Term term) {
        this.term = term;
        this.threshold = 0.0;
    }

    public Summation(Term term, double threshold) {
        this.term = term;
        this.threshold = threshold;
    }

    public double sumToInfinity(double from, double inc) {
        SuanShuUtils.assertOrThrow(this.threshold > 0.0 ? null : new RuntimeException("the convergence threshold is 0; summing will not stop"));
        double a2 = 0.0;
        double a3 = from;
        while (true) {
            double d2;
            double a4 = this.term.evaluate(a3);
            if (Math.abs(d2) < this.threshold) break;
            a2 += a4;
            a3 += inc;
        }
        return a2;
    }

    public static interface Term {
        public double evaluate(double var1);
    }
}

