/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.Substitution;

public class StandardInterval
extends Substitution {
    public final double a;
    public final double b;

    public StandardInterval(final double a2, final double b2) {
        super(new UnivariateRealFunction(){
            {
                1 a22;
            }

            @Override
            public double evaluate(double t) {
                return ((b2 - a2) * t + (a2 + b2)) / 2.0;
            }
        }, new UnivariateRealFunction(){
            {
                2 a22;
            }

            @Override
            public double evaluate(double t) {
                return (b2 - a2) / 2.0;
            }
        });
        this.a = a2;
        this.b = b2;
    }

    @Override
    public double tb() {
        return 1.0;
    }

    @Override
    public double ta() {
        return -1.0;
    }
}

