/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.Substitution;

public class PowerLawSingularity
extends Substitution {
    public final double a;
    public final PowerLawSingularityType type;
    public final double b;
    public final double gamma;

    @Override
    public double ta() {
        return 0.0;
    }

    public PowerLawSingularity(final PowerLawSingularityType type, final double gamma, final double a2, final double b2) {
        super(new UnivariateRealFunction(){
            {
                1 a22;
            }

            @Override
            public double evaluate(double t) {
                switch (type) {
                    case LOWER: {
                        return Math.pow(t, 1.0 / (1.0 - gamma)) + a2;
                    }
                    case UPPER: {
                        do {
                        } while (false);
                        return b2 - Math.pow(t, 1.0 / (1.0 - gamma));
                    }
                }
                throw new IllegalArgumentException("unrecognized singularity type");
            }
        }, new UnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double t) {
                return Math.pow(t, gamma / (1.0 - gamma)) / (1.0 - gamma);
            }
        });
        this.type = type;
        this.gamma = gamma;
        this.a = a2;
        this.b = b2;
    }

    @Override
    public double tb() {
        return Math.pow(this.b - this.a, 1.0 - this.gamma);
    }

    public static final class PowerLawSingularityType
    extends Enum<PowerLawSingularityType> {
        public static final /* enum */ PowerLawSingularityType UPPER = new PowerLawSingularityType();
        private static final /* synthetic */ PowerLawSingularityType[] E;
        public static final /* enum */ PowerLawSingularityType LOWER = new PowerLawSingularityType();

        public static PowerLawSingularityType[] values() {
            return (PowerLawSingularityType[])E.clone();
        }

        public static PowerLawSingularityType valueOf(String name) {
            return Enum.valueOf(PowerLawSingularityType.class, name);
        }

        static {
            PowerLawSingularityType[] powerLawSingularityTypeArray = new PowerLawSingularityType[2];
            powerLawSingularityTypeArray[0] = UPPER;
            powerLawSingularityTypeArray[1] = LOWER;
            E = powerLawSingularityTypeArray;
        }

        private PowerLawSingularityType() {
            PowerLawSingularityType a2;
        }
    }
}

