/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.Substitution;

public class DoubleExponential
extends Substitution {
    public final double a;
    public final UnivariateRealFunction f;
    private double E = 0.001;
    public final double c;
    public final double b;

    @Override
    public double tb() {
        double a2 = 4.3;
        if (this.f != null) {
            double a3 = Double.NaN;
            while (Double.isInfinite(a3 = this.b(a2 -= this.E)) || Double.isNaN(a3)) {
            }
        }
        return a2;
    }

    @Override
    public double ta() {
        double a2 = -4.3;
        if (this.f != null) {
            double a3 = Double.NaN;
            while (Double.isInfinite(a3 = this.b(a2 += this.E)) || Double.isNaN(a3)) {
            }
        }
        return a2;
    }

    public DoubleExponential(UnivariateRealFunction f2, double c2, double a2, double b2) {
        this(DoubleExponential.b(c2, a2, b2), DoubleExponential.m(c2, a2, b2), f2, c2, a2, b2);
    }

    public DoubleExponential(UnivariateRealFunction a2, UnivariateRealFunction a3, UnivariateRealFunction a4, double a5, double a6, double a7) {
        super(a2, a3);
        DoubleExponential a8;
        a8.a = a6;
        a8.b = a7;
        a8.c = a5;
        a8.f = a4;
    }

    private static UnivariateRealFunction m(double a2, final double a3, final double a4) {
        return new UnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double t) {
                double a2 = Math.exp(-2.0 * Math.sinh(t));
                return 2.0 * (a4 - a3) * a2 / (1.0 + a2) / (1.0 + a2) * Math.cosh(t);
            }
        };
    }

    private static UnivariateRealFunction b(final double a2, final double a3, final double a4) {
        return new UnivariateRealFunction(){
            {
                1 a22;
            }

            @Override
            public double evaluate(double t) {
                return 0.5 * (a4 + a3) + 0.5 * (a4 - a3) * Math.tanh(a2 * Math.sinh(t));
            }
        };
    }

    private double b(double a2) {
        DoubleExponential a3;
        double a4 = a3.x.evaluate(a2);
        double a5 = a3.dx.evaluate(a2);
        double a6 = a3.f.evaluate(a4) * a5;
        return a6;
    }
}

