/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Trapezoidal;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Simpson
implements IterativeIntegrator {
    private Trapezoidal k;
    public final int maxIterations;
    public final double precision;
    private double L;
    private double E;

    @Override
    public double integrate(UnivariateRealFunction f2, double a2, double b2) {
        int a3;
        double a4 = Double.NaN;
        double a5 = Double.NaN;
        int n = a3 = 1;
        while (n <= this.maxIterations) {
            a4 = a5;
            a5 = this.next(a3, f2, a2, b2, a4);
            if (a3 > 3 && DoubleUtils.relativeError(a5, a4) < this.precision) break;
            n = ++a3;
        }
        return a5;
    }

    public Simpson(double precision, int maxIterations) {
        this.k = new Trapezoidal(precision, maxIterations);
        this.maxIterations = maxIterations;
        this.precision = precision;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public double h() {
        return this.k.h();
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public double next(int iteration, UnivariateRealFunction f2, double a2, double b2, double sum) {
        if (iteration == 1) {
            this.L = this.k.next(1, f2, a2, b2, sum);
            this.E = this.k.next(2, f2, a2, b2, this.L);
        } else {
            this.L = this.E;
            this.E = this.k.next(iteration + 1, f2, a2, b2, this.L);
        }
        return (4.0 * this.E - this.L) / 3.0;
    }
}

