/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.IterativeIntegrator;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class EulerMaclaurin
implements IterativeIntegrator {
    public final int maxIterations;
    public final double precision;
    private double L;
    public final int rate;
    private int E = 1;
    public final NewtonCotesType type;

    @Override
    public double next(int iter, UnivariateRealFunction f2, double a2, double b2, double sum0) {
        SuanShuUtils.assertArgument(iter > 0, "iteration count must be +ve", new Object[0]);
        double a3 = sum0;
        if (iter == 1) {
            this.L = b2 - a2;
            this.E = 1;
            switch (this.type) {
                case CLOSED: {
                    a3 = 0.5 * this.L * (f2.evaluate(a2) + f2.evaluate(b2));
                    break;
                }
                case OPEN: {
                    do {
                    } while (false);
                    a3 = this.L * f2.evaluate((a2 + b2) / 2.0);
                }
            }
        } else {
            int a4;
            this.L /= (double)this.rate;
            this.E *= this.rate;
            double a5 = 0.0;
            double a6 = a2;
            int n = a4 = 1;
            while (n < this.E) {
                a6 += this.L;
                if (a4 % this.rate != 0) {
                    a5 += f2.evaluate(a6);
                }
                n = ++a4;
            }
            a3 = sum0 / (double)this.rate + this.L * a5;
        }
        return a3;
    }

    public EulerMaclaurin(int rate, NewtonCotesType type, double precision, int maxIterations) {
        this.rate = rate;
        this.type = type;
        this.precision = precision;
        this.maxIterations = maxIterations;
    }

    @Override
    public double integrate(UnivariateRealFunction f2, double a2, double b2) {
        int a3;
        double a4 = Double.NaN;
        double a5 = Double.NaN;
        int n = a3 = 1;
        while (n <= this.maxIterations) {
            a4 = a5;
            a5 = this.next(a3, f2, a2, b2, a4);
            if (a3 > 3 && DoubleUtils.relativeError(a5, a4) < this.precision) break;
            n = ++a3;
        }
        return a5;
    }

    @Override
    public double h() {
        return this.L;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    public static final class NewtonCotesType
    extends Enum<NewtonCotesType> {
        public static final /* enum */ NewtonCotesType OPEN;
        public static final /* enum */ NewtonCotesType CLOSED;
        private static final /* synthetic */ NewtonCotesType[] E;

        public static NewtonCotesType[] values() {
            return (NewtonCotesType[])E.clone();
        }

        static {
            CLOSED = new NewtonCotesType();
            OPEN = new NewtonCotesType();
            NewtonCotesType[] newtonCotesTypeArray = new NewtonCotesType[2];
            newtonCotesTypeArray[0] = CLOSED;
            newtonCotesTypeArray[1] = OPEN;
            E = newtonCotesTypeArray;
        }

        private NewtonCotesType() {
            NewtonCotesType a2;
        }

        public static NewtonCotesType valueOf(String name) {
            return Enum.valueOf(NewtonCotesType.class, name);
        }
    }
}

