/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Trigamma
extends UnivariateRealFunction {
    private static final double L = 1.0E-4;
    private static final double E = 30.0;

    @Override
    public double evaluate(double x) {
        double a2 = 0.0;
        if (Double.isNaN(x)) {
            throw new RuntimeException("x = NaN");
        }
        if (DoubleUtils.compare(x, 0.0) == 0) {
            a2 = Double.POSITIVE_INFINITY;
        } else if (x < 0.0) {
            a2 = Math.pow(Math.PI / Math.sin(Math.PI * x), 2.0) - this.evaluate(1.0 - x);
        } else if (x > 0.0 && x < 1.0E-4) {
            a2 = 1.0 / x / x + 1.6449340668482264 + -2.4041138063191885 * x;
        } else if (x >= 30.0) {
            double a3 = 1.0 / x / x;
            a2 = 0.5 * a3 + (1.0 + a3 * (0.16666666666666666 + a3 * (-0.03333333333333333 + a3 * (0.023809523809523808 + a3 * (-0.03333333333333333 + a3 * 5.0 / 66.0))))) / x;
        } else {
            a2 = this.evaluate(x + 1.0);
            a2 += 1.0 / x / x;
        }
        return a2;
    }
}

